# Model/Ages clustering constants:
VALUE_REGRESSION_MODEL_ANALYSIS_ID = "FRAsU3XU"
VALUE_REGRESSION_MODEL_ML_TASK_ID = "vRq0uNuR"
VALUE_REGRESSION_TRAINING_RECIPE_NAME = "train_Predict_future_clv__regression_"
VALUE_REGRESSION_DEPLOYED_MODEL_ID = "8DH8qTLw"

# Cluster classification constants:
CLUSTER_CLASSIFICATION_MODEL_ANALYSIS_ID = "FRAsU3XU"
CLUSTER_CLASSIFICATION_MODEL_ML_TASK_ID = "9Phtxfai"
CLUSTER_CLASSIFICATION_TRAINING_RECIPE_NAME = "train_Predict_future_clv_cluster__multiclass__1"
CLUSTER_CLASSIFICATION_DEPLOYED_MODEL_ID = "gnmpBoi9"

# lifetime model constants:
LIFETIME_MODEL_ANALYSIS_ID = "2RPPtcOI"
LIFETIME_MODEL_ML_TASK_ID = "AvOAZzLr"
LIFETIME_TRAINING_RECIPE_NAME = "train_lifetime_prediction"
LIFETIME_DEPLOYED_MODEL_ID = "FGnegBQF"

# automation
NOTRAIN_SCENARIO = "[CLV]_build_all_flow_notrain"
RETRAIN_SCENARIO = "CLVBUILD_ALL_FLOW"

# programatic join for data enrichment
MONTHLY_FEATURES_KEEP_COLUMNS = [
    "ref_date",
    "customer_id",
    "transaction_year",
    "transaction_month",
    "month_transaction_date_min",
    "month_transaction_date_max",
    "transaction_day_count",
    "month_number_of_transaction",
    "month_number_product",
    "month_quantity_sum",
    "month_total_value",
]


RFM_KEEP_COLUMNS = [
    "recency",
    "frequency",
    "monetary_value",
    "density",
    "rfm_score",
    "rfm_score_scaled",
    "rfm_segment",
    "rfmd_score",
    "rfmd_score_scaled",
    "rfmd_segment",
    "segment_label",
]

NUMERICAL_VALUES_PROCESSING = {
    "generate_derivative": False,
    "numerical_handling": "REGULAR",
    "missing_handling": "IMPUTE",
    "missing_impute_with": "MEDIAN",
    "impute_constant_value": 0.0,
    "keep_regular": False,
    "rescaling": "AVGSTD",
    "quantile_bin_nb_bins": 4,
    "binarize_threshold_mode": "MEDIAN",
    "binarize_constant_threshold": 0.0,
    "datetime_cyclical_periods": [],
    "role": "INPUT",
    "type": "NUMERIC",
    "customHandlingCode": "",
    "customProcessorWantsMatrix": False,
    "sendToInput": "main",
}

CATEGORICAL_VALUES_PROCESSING = {
    "category_handling": "DUMMIFY",
    "missing_handling": "NONE",
    "missing_impute_with": "MODE",
    "dummy_clip": "MAX_NB_CATEGORIES",
    "cumulative_proportion": 0.95,
    "min_samples": 10,
    "max_nb_categories": 20,
    "max_cat_safety": 200,
    "nb_bins_hashing": 1048576,
    "hash_whole_categories": True,
    "dummy_drop": "AUTO",
    "impact_method": "M_ESTIMATOR",
    "impact_m": 10,
    "impact_kfold": True,
    "impact_kfold_k": 5,
    "impact_kfold_seed": 1337,
    "ordinal_order": "COUNT",
    "ordinal_ascending": False,
    "ordinal_default_mode": "HIGHEST",
    "ordinal_default_value": 0,
    "frequency_default_mode": "EXPLICIT",
    "frequency_default_value": 0.0,
    "frequency_normalized": True,
    "role": "INPUT",
    "type": "CATEGORY",
    "customHandlingCode": "",
    "customProcessorWantsMatrix": False,
    "sendToInput": "main",
}

RFM_PREPROCESSING = {
    "recency": NUMERICAL_VALUES_PROCESSING,
    "frequency": NUMERICAL_VALUES_PROCESSING,
    "monetary_value": NUMERICAL_VALUES_PROCESSING,
    "density": NUMERICAL_VALUES_PROCESSING,
    "rfm_score": NUMERICAL_VALUES_PROCESSING,
    "rfm_score_scaled": NUMERICAL_VALUES_PROCESSING,
    "rfm_segment": CATEGORICAL_VALUES_PROCESSING,
    "rfmd_score": NUMERICAL_VALUES_PROCESSING,
    "rfmd_score_scaled": NUMERICAL_VALUES_PROCESSING,
    "rfmd_segment": CATEGORICAL_VALUES_PROCESSING,
    "segment_label": CATEGORICAL_VALUES_PROCESSING,
    "recency_avg": NUMERICAL_VALUES_PROCESSING,
    "frequency_avg": NUMERICAL_VALUES_PROCESSING,
    "monetary_value_avg": NUMERICAL_VALUES_PROCESSING,
}


FALLBACK_CONNECTIONS = {
    "monthly_granularity": ["compute_monthly_granularity_joined",],
    "ml_data_train": ["train_lifetime_prediction", "score_ml_data_train"],
    "ml_data_test": ["train_lifetime_prediction", "score_ml_data_test"],
    "ml_data_test_clustered": ["compute_test_output"],
    "ml_data_train_with_lifetime": ["compute_ml_data_train_with_lifetime_prepared"],
    "ml_data_test_with_lifetime": ["compute_ml_data_test_with_lifetime_prepared"],
    "ml_data_test_scored": ["compute_ml_data_test_scored_prepared"],
    "inference_data_with_lifetime": ["compute_inference_data_with_lifetime_prepared"],
    "inference_data_current_cluster": ["score_inference_data_with_lifetime_prepared"],
    "inference_data_with_lifetime_prepared_scored": ["compute_output_data"],
    "inference_data_clustered": ["score_inference_data_clustered"],
    "inference_data_clustered_with_classification": ["compute_inference_output"],
    "ml_data_test_classification": ["compute_ml_data_test_classification_prepared"],
}

FALLBACK_DATASETS = list(FALLBACK_CONNECTIONS.keys()) + [
    "regression_metrics",
    "classification_metrics",
    "inference_metrics",
    "history_clv_data_clustered",
    "cluster_counts",
    "manual_metrics",
    "lifetime_classification_manual_metrics",
    "regression_classification_manual_metrics",
    "classification_manual_metrics",
]
FLOW_INPUT_DATASETS = [
    "transactions_history",
    "customer_metadata",
]

FLOW_INPUT_DATASETS_TO_PRESERVE = []


backward_window_columns_rename = {
    "month_transaction_date_min_min": "window_transaction_date_min",
    "month_transaction_date_max_max": "window_transaction_date_max",
    "transaction_day_count_sum": "transaction_day_count",
    "ref_date_count": "backward_window_count",
    "month_number_of_transaction_sum": "window_number_of_transaction",
    "month_number_product_sum": "window_number_product",
    "month_total_value_sum": "window_total_value",
    "month_quantity_sum_sum": "window_quantity",
}

backward_window_aggregation = {
    "ref_date": ["value", "count"],
    "transaction_year": ["value"],
    "transaction_month": ["value"],
    "customer_id": ["value"],
    "month_transaction_date_min": ["min"],
    "month_transaction_date_max": ["max"],
    "transaction_day_count": ["sum"],
    "month_number_of_transaction": ["sum"],
    "month_number_product": ["sum"],
    "month_total_value": ["sum"],
    "month_quantity_sum": ["sum"],
}

full_backward_window_aggregation = {
    "ref_date": ["value", "count"],
    "customer_id": ["value"],
    "month_number_of_transaction": ["sum"],
    "month_number_product": ["sum"],
    "month_quantity_sum": ["sum"],
    "month_total_value": ["avg", "sum"],
}
full_backward_window_columns_rename = {
    "ref_date_count": "customer_month_age",
    "month_number_of_transaction_sum": "cumulative_transaction_sum",
    "month_number_product_sum": "cumulative_number_product_sum",
    "month_quantity_sum_sum": "cumulative_quantity_sum",
    "month_total_value_avg": "total_value_average",
    "month_total_value_sum": "cumulative_value_sum",
}

full_backward_window_rfm_aggregation = {
    "recency": ["avg"],
    "frequency": ["avg"],
    "monetary_value": ["avg"],
}

classification_test_columns = [
    "ref_date",
    "customer_id",
    "current_clv_cluster",
    "future_clv_cluster",
    "prediction_future_clv_cluster",
    "customer_month_age",
    "cumulative_transaction_sum",
    "total_value_average",
    "cumulative_value_sum",
    "cumulative_number_product_sum",
    "cumulative_quantity_sum",
]

classification_test_columns_alias = {}

regression_test_columns = [
    "low_transaction_number_customer",
    "window_total_value",
    "future_clv",
    "future_average_monthly_value",
    "prediction_lifetime",
    "prediction_lifetime_future_monthly_average_value",
    "prediction",
    "prediction_ml_future_monthly_average_value",
    "future_clv_cluster_predicted",
    "future_clv_cluster_lifetime",
    "predicted_increase",
    "lifetime_predicted_increase",
    "clv_forward_increase",
    "average_monthly_value",
]

regression_test_columns_alias = {
    "window_total_value": "current_clv",
    "prediction": "prediction_ml",
    "future_clv_cluster_predicted": "ml_regression_future_clv_cluster",
    "future_clv_cluster_lifetime": "lifetime_regression_future_clv_cluster",
    "predicted_increase": "ml_predicted_increase",
}

future_cluster_aggregation = {
    "current_clv_cluster": ["avg"],
    "prediction_future_clv_cluster": ["avg"],
    "low_transaction_number_customer": ["avg"],
    "current_clv": ["avg"],
    "future_clv": ["avg"],
    "prediction_lifetime": ["avg"],
    "prediction_ml": ["avg"],
    "ml_regression_future_clv_cluster": ["avg"],
    "lifetime_regression_future_clv_cluster": ["avg"],
}

inference_column_mapping = {
    "regression": "ml_regression_future_clv_cluster",
    "lifetime": "future_clv_cluster_lifetime",
    "classification": "prediction_future_clv_cluster",
    "naive":"current_clv_cluster"
}

monthly_full_forward_columns = [
    "customer_month_age",
    "cumulative_transaction_sum",
    "total_value_average",
    "cumulative_value_sum",
    "cumulative_number_product_sum",
    "cumulative_quantity_sum",
]