from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.recipes.recipe_commons import get_recipe_settings_and_dictionary


def forward_window_features():
    project, variables = get_current_project_and_variables()

    # Forward window #
    # aggregations/schema should not change but are left here as reference in case of customization
    monthly_forward_recipe_name = "compute_monthly_forward_value"

    # forward_window_aggregation = {
    #     "ref_date": ["value", "count"],
    #     "customer_id": ["value"],
    #     "month_total_value": ["sum"],
    # }

    # columns_rename = {"month_total_value_sum": "clv_forward_increase", "ref_date_count": "forward_window_count"}

    # define_window_recipe_aggregations(project, monthly_forward_recipe_name, forward_window_aggregation)
    recipe_settings, _ = get_recipe_settings_and_dictionary(
        project, monthly_forward_recipe_name, False
    )

    recipe_payload = recipe_settings.get_json_payload()
    recipe_payload["windows"][0]["followingRows"] = (
        int(variables["standard"]["sliding_forward_window_app"]) - 1
    )
    # recipe_payload["outputColumnNameOverrides"] = columns_rename

    recipe_settings.set_json_payload(recipe_payload)
    recipe_settings.save()
    # update_recipe_ouput_schema(project, monthly_forward_recipe_name)
