import dataiku

from clv_forecast.constants import future_cluster_aggregation
from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.recipes.group_recipe import define_group_recipe_aggregations
from dku_utils.projects.recipes.recipe_commons import (
    update_recipe_ouput_schema,
    adapt_recipe_engine_to_priority_and_availability,
)


def groupby_exploration():
    project, variables = get_current_project_and_variables()
    recipe_name = "compute_ml_data_test_clustered_by_future_clv_cluster_predicted"

    column_aggregations_mapping = future_cluster_aggregation

    if variables["standard"]["leverage_customer_metadata_app"]:
        rfm_dataset = dataiku.Dataset(
            variables["standard"]["customer_metadata_dataset_app"]
        )

        schema = rfm_dataset.read_schema()
        columns = list(
            filter(
                lambda name: name != "customer_id",
                map(lambda pair: pair["name"], schema),
            )
        )

        for column in columns:
            if column in variables["standard"]["numerical_metadata_app"]:
                column_aggregations_mapping.update({column: ["avg"]})

    define_group_recipe_aggregations(
        project, recipe_name, column_aggregations_mapping, True
    )
    update_recipe_ouput_schema(
        project, "compute_ml_data_test_clustered_by_future_clv_cluster_predicted"
    )
    adapt_recipe_engine_to_priority_and_availability(
        project, "compute_ml_data_test_clustered_by_future_clv_cluster_predicted"
    )
