import numpy as np


def quantile_filter(array, quantile_min=0.25, quantile_max=0.75):
    if len(array) == 0:
        return array
    max_value, min_value = np.quantile(array, [quantile_max, quantile_min])
    array = np.clip(array, min_value, max_value)
    return array
