# -*- coding: utf-8 -*-
import dataiku

from clv_forecast.utils.clustering import apply_clustering

# Read recipe inputs
inference_data_with_lifetime_prepared = dataiku.Dataset(
    "inference_data_with_lifetime_prepared"
)
inference_data_with_lifetime_prepared_df = (
    inference_data_with_lifetime_prepared.get_dataframe()
)

inference_data_with_lifetime_prepared_df["current_clv_cluster"] = apply_clustering(
    inference_data_with_lifetime_prepared_df["average_monthly_value"]
)

inference_data_current_cluster_df = inference_data_with_lifetime_prepared_df

# Write recipe outputs
inference_data_current_cluster = dataiku.Dataset("inference_data_current_cluster")
inference_data_current_cluster.write_dataframe(
    inference_data_current_cluster_df, infer_schema=False
)
