In this zone, the transition matrices are built from the loan performance data. 

![Transition Matrices Zone.png](KoW23AGZFrQs)

Both the Through-the-Cycle (TTC) matrix and the Point-in-Time (PIT) matrices are built using visual recipes along with the $`x`$ density coordinates of each bin, to compute the z-score afterwards, as described in the [Probability of Default article](article:4).

First, a [windows recipe](recipe:compute_loan_performance_transition) computes for each loan the credit status for the next period. Then two grouping recipes will compute the matrices. The [compute_smoothed_transition_matrix](recipe:compute_smoothed_transition_matrix) takes care of the TTC matrix by agregating using credit status and next credit status as keys whereas [compute_transition_matrices](recipe:compute_transition_matrices) handles the PIT by adding the quarter as a key.

The two sets of matrices are stacked back together and then go through a series of visual recipes to compute the probabilities of transitions and their equivalent as $`x`$ density coordinates:
 - The total UPB is computed for each transition starting point, the key being quarter and credit status ([compute_transition_matrices_all_total](recipe:compute_transition_matrices_all_total)).
 - The probability is computed as the ratio between the transition UPB and the total UPB ([compute_transition_matrices_probability](recipe:compute_transition_matrices_probability)).
 - For each transition starting point the cumulative probability is computed ([compute_transition_matrices_cum_probability](recipe:compute_transition_matrices_cum_probability)).
 - Cumulative probabilities are converted into the normal density ([compute_transition_matrices_bins](recipe:compute_transition_matrices_bins)).
 - The previous bin is retrieved for each row ([compute_transition_matrices_bin_bounds](recipe:compute_transition_matrices_bin_bounds)).
 - Finally the initial normal density coordinate is set to -Infinity for each transition starting point ([compute_transition_matrices_bin_bounds_final](recipe:compute_transition_matrices_bin_bounds_final)).
 
Then the two types of transition matrices are split back.