This zone handles the Loss Given Default (LGD) inference on the data.

![Loss Given Default Zone.png](AAkDdHbzs6fF)

First, the initial value of the asset is inferred from the knowledge of the initial Loan-to-Value (LTV) and Unpaid Principal Balance (UPB). This is joined together with the worst peak-to-trough ratio per state computed previously and the extrapolated payment dates for all loans. From there, the LGD is computed in the [prepare recipe](recipe:compute_updated_loan_to_value) as the UPB minus the estimated value of the asset at that point, which is in turn valued as the initial value removed from the peak-to-trough ratio over which a haircut is applied to account for additional costs. The final LGD ratio, is this LGD capped by the UPB, divided by the UPB.

```math
LGD_{ratio} = \frac{UPB - \max(0, \min(UPB, initial\_value \times P/T \times 70\%))}{UPB}
```

The LGD is then agregated at a state and date level to get a ratio that can be applied together with the transition matrices.