In this zone, the Z-score is built from the transition matrices, a linear model is trained on the macroeconomic data and forecasts are scored against this model.

![Z Score Modeling.png](M2vwJhVA1FHH)

First the TTC transition matrix dataset is joined to the PIT transition matrices datasets. This will be the input of the Z-score extraction described in this [article](article:4).

The Z-score extraction is achieved in [the python recipe](recipe:compute_z_score): 
 - The objective function for each quarter is defined: this is what $`z`$ optimises.
 - The global objective function on $`z`$ variance is defined: this is what $`\rho`$ optimises.
 - First $`\rho`$ is optimized and saved as a project variable.
 - Then using this value, $`z`$ is optimised and saved in the output dataset.

The extracted Z-score is joined to the prepared macroeconomic data to create the input of the [linear regression model](saved_model:h00UdaWH) that is handled using the visual ML module.

We are looking to fit an ordinary linear regression to predict the Z-score, using some of the macroeconomic variables or their lags that have been previously prepared. To select the variables, we iterate on the feature reduction methods to find the top three variables that are most often relevant. We end up using these three variables:
 - the BBB Corporate Yield lagged twice.
 - the Mortgage Interest Rate lagged three times.
 - the Market Volatility Index lagged once.

This selection can be adapted based on the user's expertise or the need for the model to be the sensitive to some specific features, like inflation. These three features are selected in the feature handling and the final model run using them, without any additional feature reduction.

The trained model is then used to score the forecasts and obtain the predicted Z scores. They are joined to the TTC transition matrix to construct the predicted forecast matrices which are built in the final [prepare recipe](recipe:compute_scenario_transition_matrices_probabilities).