The Model Analysis explores three components of the modelling.

# Macroeconomic Indicators

The macroeconomic indicators are the economic timeseries that relate to the credit cycle. Some of these variables will be used as predictors in the probability of default model.

![Macro 1.png](otGbVTyk00R8)

All variables cannot be displayed at the same time because they don't have the same claim and they are too many, so the user can make selection out of them with the left-hand side filters. In this first time series chart, the historical data is displayed.

![Macro 2.png](iPCjZ5v3VK9w)

In the chart just after, we are looking at the forecast scenarios, they might follow a baseline scenario and a more adverse one like in our example. It is reflected at different levels depending on the variable.

![Macro 3.png](NytFSegTkzAa)

Finally a correlation matrix was built using a Statistics card and it is displayed here. It provides a fast and visual way to identify the groups of variable that closely correlated to each other, and eventually have a first view on the variables that have more chance of predicting the credit variable z-score. We will add lags on each of the economic variables to find the right delay between the economic observation and the actual credit consequence.

# Probability of Default Model

The probability of default consists in building transition matrices, extracting a z-score and training a linear regression to predict it against macroeconomic variables. More information on this approach can be found [here](article:4). 

![PD 1.png](eO4e7yOiOSAE)

The Through-the-Cycle matrix gives a sense of how likely a creditor from one credit status is to move to another one over a quarter. The riskier the credit status, the more likely the loan is to default. Over time, these transition matrices vary and the z-score below represents this variation against the long-term dynamic.

![PD 2.png](eC43H9zScwrP)

The z-score is one-dimension representation of the Point-in-Time transition matrices dynamic. On the line chart, we can easily identify the periods of distress and better economic situations.

![PD 3.png](REYXq3FiWq3f)

Finally a simple linear regression fits the z-score against three economic variables. We can observe the regression coefficients along with some metrics about the model, evaluated using a k-fold validation.

# Loss Given Default

Loss Given Default is simply evaluated using Peak-to-Trough.

![LGD 1.png](rZCi7tpWP0Oc)

House Price indices are available for all states, and upon examination, it becomes evident that certain timeseries exhibit more significant fluctuations compared to others. These states with more pronounced Peak-to-Trough variations are generally considered to be riskier in terms of housing market stability.

![LGD 2.png](qmavA1vfVJGa)

The two bottom charts show the Peak-to-Trough distribution and the states with the worst values.
