# Modeling

Typically three types of models are needed to run Expected Credit Losses analyses, they will be explained in more detail in their dedicated articles:

- [Probability of Default (PD)](article:4): The likelihood of a loan defaulting.
- [Loss Given Default (LGD)](article:5): When the default happens, which share of the remaining capital is lost and cannot be recovered.
- [Exposure At Default (EAD)](article:6): The remaining balance at some point in the future, when the loan might default.

In the end, ECL is computed as:

```math
ECL = EAD \times PD \times LGD
```

# Data

The mortgage data comes from Freddie Mac, the link to the data documentation is available in the [resources](article:9). We need the historical performance of the loans to understand how they were affected by economic conditions.

Economic Data both for history and forecast come from The Federal Reserve, the reference is in linked in the [resources](article:9).

Housing Price Indices by State come from the [Federal Housing Finance Agency](https://www.fhfa.gov/DataTools/Downloads/Pages/House-Price-Index-Datasets.aspx).

This exhaustive historical data is needed to build the models. However, when running the ECL computation, historical data is no longer needed, the models are applied to the most recent snapshot agains the economic scenarios.