# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from credit_scoring import score

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Read recipe inputs
score_card = dataiku.Dataset("score_card")
score_card_df = score_card.get_dataframe()
applications_validation = dataiku.Dataset("applications_validation")
applications_validation_df = applications_validation.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
applications = score(score_card_df, applications_validation_df)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
applications_scored = dataiku.Dataset("applications_scored")
applications_scored.write_with_schema(applications)