In this article, we list a few additional steps beyond the current solution. Credit Scoring is a very broad topic that may not be addressed fully in a single project, and in practice would be tackled via multiple projects combined together. More information about Credit Scoring can be found in the [resources](article:4).

# Segmentation

Applicants are often first segmented before building the scorecard model. The segmentation can be based on multiple criteria, using inputs coming from the business or even unsupervised learning. Its ultimate goal is to build a more precise model by building multiple smaller models on similar-looking applicants. Each of these smaller models can extract more meaningful patterns from the data and may have distinct sets of important features included in them. After the segmentation takes place, thanks to the scorecard scaling described [previously](article:10), final scores are comparable from one segment to another.

# Reject Inference

The data used to build credit models is made only of accepted applicants, for which we know after some time if they turned out to be good or bad creditors. Hence, the data is biased, so the goal of reject inference is to find ways to include rejected applicants in the analysis. A few techniques are available to account for rejects:

- Assign all rejects to bad: this pretty blunt approach is very conservative and may result in losing significant potential applicants.
- Ignore rejects: the approach taken in this project, where rejects are not acknowledged.
- Let through some rejects: to have a sense of the distribution of goods and bad for the population of rejects and use this small sample to extrapolate.
- Use Bureau Data: some information about the rejects may be available in bureaux to infer if they are good or bad creditors.
- Augment Data: multiple techniques have been developed to assign their target to rejects based on their similarity with accepted, or by using a model to score them and assume this score will say if they are good or bad.

# Strategy

The strategy is the overall decision process in which the scorecard is embedded. Even for a simple loan origination decision, the workflow to determine whether or not it will be granted might be more complex than scoring the application based on a threshold accept or reject. Other considerations can impact the decision, such as the potential future revenue the customer can return or the fact that it is at risk of churn. In practice, multiple scores are computed to assess all potential risks and returns to make a final informed decision. Therefore, this scorecard should be seen essentially as a risk measure and not as decision tool, it is only one part of a more complex process.

# Model Lifecycle

Once a scorecard is put into production with all its approvals and sign-offs, it does not mean that it will perform as expected over a long period of time. Indeed, economic conditions will evolve over time, along with applicants' characteristics, which might significantly affect the quality of the scorecard. Hence, great care must be taken when monitoring such models to ensure that performance does not deviate from accepted variations. And in such cases, processes can be put in place to either update the model with more recent data to reflect the latest changes or eventually start a new scorecard development. A model built on obsolete data might have had great historical performances but will fail to perform accordingly in production.


