import dataiku
from dataiku import pandasutils as pdu
import pandas as pd
from dataiku import insights
from datetime import datetime, timedelta 
import json
import plotly.express as px
import plotly.graph_objects as go
from dates_handling.type_conversions import from_datetime_to_dss_string_date


def save_html(title, html_bytes):
    insights.save_data(
        id=title, 
        payload=html_bytes, 
        content_type='text/html',
        label=title)
    

def study_title_html(title):
    font_size = '22px'
    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"</style>"
        f"<h1>{title}</h1>"
    )
    return html_content.encode()


def study_summary_html(summary, details=None):

    font_size = '14px'
    title_color = '#808080'  # Grey color for titles

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>body {{font-family: 'Source Sans Pro', sans-serif;}} h1 {{font-size: {font_size};}} .title {{font-weight: bold; color: {title_color};}} .content {{margin-left: 20px;}}</style>"
        f"<div class='content'><div class='title'>Brief Summary</div>{summary}</div>"
    )
    if details:
        html_content += (        
            f"<br>"
            f"<div class='content'><div class='title'>Detailed Description</div>{details}</div>")
        
    return html_content.encode()


def status_style(Study_status):
    Study_status = [l.lower() for l in Study_status.split('_')]
    Study_status = ' '.join(Study_status)
    font_size = '14px'
    border_color_recruiting = '#5FAD56'  # Border color for "recruiting" status
    border_color_other = '#F2C14E'  # Border color for other statuses
    if Study_status in ['recruiting', 'not yet recruiting']:
        border_color = border_color_recruiting
    else:
        border_color = border_color_other

    return (
        f"<div class='status-box' style='border: 2px solid {border_color}; background-color: {border_color}; padding: 10px; display: inline-block; border-radius: 8px;'>"
        f"    {Study_status}"
        f"</div>"
    )


def study_status_html(status):
    font_size = '14px'
    formated_status = status_style(status)
    centered_status = f"<div style='display: flex; justify-content: center;'>{formated_status}</div>"
    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"</style>"
        f"    {centered_status}"
    )
    return html_content.encode()


def enrollment_type_style(enrollment_count, enrollment_type):
    enrollment_count = int(enrollment_count)
    font_size = '14px'
    border_color_actual = '#5FAD56'  # Border color for "ACTUAL" status
    border_color_other = '#F2C14E'  # Border color for other statuses
    if enrollment_type == "ACTUAL":
        border_color = border_color_actual
        color = 'white'
    else:
        border_color = border_color_other
        color = 'black'

    formatted_enrollment_type = (
        f"<div class='status-box' style='border: 2px solid {border_color}; background-color: {border_color}; color: {color}; padding: 10px; display: inline-block; border-radius: 8px;'>"
        f"    {enrollment_type}"
        f"</div>"
    )

    centered_enrollment_type = (
        f"<div style='display: flex; justify-content: center;'>"
        f"    <div style='display: inline-block; border: 2px solid transparent; padding: 10px; border-radius: 8px;'>{enrollment_count}</div>"
        f"    {formatted_enrollment_type}"
        f"</div>"
    )

    return centered_enrollment_type


def study_enrollment_html(enrollment_count, enrollment_type):
    font_size = '14px'
    enrollment_status_html = enrollment_type_style(enrollment_count, enrollment_type)

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"</style>"
        f"    {enrollment_status_html}"
    )

    return html_content.encode()


def score_style(score):
    font_size = '14px'
    border_color_high = '#4D9078'  # Border color for "high" status
    border_color_medium = '#F78154'  # Border color for "medium" status
    border_color_low = '#B4436C'  # Border color for low status

    if score == 'High':
        border_color = border_color_high
    elif score == 'Medium':
        border_color = border_color_medium
    else:
        border_color = border_color_low

    return (
        f"<div class='status-box' style='border: 2px solid {border_color}; color: white; background-color: {border_color}; padding: 10px; display: inline-block; border-radius: 8px;'>"
        f"    {score}"
        f"</div>"
    )


def study_score_html(sdoh_include):
    if sdoh_include:
        score_sdoh = dataiku.Dataset("selected_study_score_w_enrollment_rate_sdoh")
        score_sdoh_df = score_sdoh.get_dataframe()
        score = score_sdoh_df.Enrolment_rate_combined.values[0]
    else:
        score = dataiku.Dataset("selected_study_scored_w_enrollment_rate_model")
        score_df = score.get_dataframe()
        score = score_df.Enrolment_rate_combined.values[0]
    font_size = '14px'
    formated_score = score_style(score)
    centered_score = f"<div style='display: flex; justify-content: center;'>{formated_score}</div>"
    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"</style>"
        f"    {centered_score}"
    )
    return html_content.encode()


def study_dates_html(startdate, primarycompletedate, enddate):
    font_size = '14px'
    bold_border = "2px solid #4A6FA5"  # Solid border, light blue
    dash_border = "2px dashed #000000"  # Dashed border, black
    padding_between_shapes = "10px"  # Adjust as needed

    # Get today's date
    today = datetime.today().date()

    # Apply different border style and background color based on the date
    def get_style_and_color(date_value):
        date_value = datetime.strptime(date_value, '%Y-%m-%d')
        if date_value.date() < today:
            return f"{bold_border}", "#4A6FA5", 'white'  # Solid border, light blue
        else:
            return f"{dash_border}", "#DBE9EE", 'black'  # Dashed border, light gray

    # Get style and color for each date element
    startdate_style, startdate_color, startdate_font = get_style_and_color(startdate)
    primarycompletedate_style, primarycompletedate_color, primarycompletedate_font = get_style_and_color(primarycompletedate)
    enddate_style, enddate_color, enddate_font = get_style_and_color(enddate)

    # Create HTML content with formatted dates in styled div elements
    date_elements = [
        {
            'title': 'Start Date',
            'date': startdate,
            'color': startdate_color,
            'style': startdate_style,
            'font_color': startdate_font,
        },
        {
            'title': 'Primary Completion Date',
            'date': primarycompletedate,
            'color': primarycompletedate_color,
            'style': primarycompletedate_style,
            'font_color': primarycompletedate_font,
        },
        {
            'title': 'Completion Date',
            'date': enddate,
            'color': enddate_color,
            'style': enddate_style,
            'font_color': enddate_font,
        }
    ]

    # Generate the formatted HTML for date elements
    formatted_dates = ''.join(
        f"<div style='background-color: {date['color']}; color: {date['font_color']}; font-weight: bold; padding: 5px; border: {date['style']}; margin-bottom: {padding_between_shapes};'>{date['title']}<br>{date['date']}</div>"
        for date in date_elements
    )

    html_content =(
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}" 
        f"    h1 {{font-size: {font_size};}}"
        f"</style>"
        f"<h1>{formatted_dates}</h1>")
    return html_content.encode()


def format_collaborators(collaborators):
    collaborator_border_color = '#C0D6DF'  # Border color for collaborators
    margin_between_items = '2.5px'  # Updated to match the margin between title and items

    # Format collaborators with border, padding, and margin, and line breaks
    collaborators_formatted = "<br>".join(
        f"<div style='border: 1px solid {collaborator_border_color}; padding: 5px; margin: {margin_between_items}; border-radius: 8px;'>{collaborator}</div>"
        for collaborator in collaborators
    )

    return collaborators_formatted


def format_lead_sponsor(leadsponsor):
    font_size = '14px'
    leadsponsor_color = '#4F6D7A'  # Border color for lead sponsor

    lead_sponsor_html = (
        f"<div style='border: 1px solid {leadsponsor_color}; padding: 5px; background-color: {leadsponsor_color}; color: white; border-radius: 8px;'>{leadsponsor}</div>"
    )

    return lead_sponsor_html


def study_sponsors_html(leadsponsor, collaborators):
    font_size = '14px'
    title_color = '#808080'  # Grey color for titles
    margin_between_items = '5px'  # Adjust as needed

    collaborators_formatted = format_collaborators(collaborators)
    lead_sponsor_html = format_lead_sponsor(leadsponsor)

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size}; margin: {margin_between_items};}}"  # Apply the margin to the title
        f"    .title {{font-weight: bold; color: {title_color};}}"
        f"    .content {{margin-left: 20px;}}"
        f"</style>"
        f"<div class='content'>"
        f"    <div class='title'>Lead Sponsor</div>"
        f"    {lead_sponsor_html}"
        f"</div>"
        f"<br>"
        f"<div class='content'>"
        f"    <div class='title'>Collaborators</div>"
        f"    {collaborators_formatted}"
        f"</div>"
    )
    return html_content.encode()


def format_conditions(conditions):
    font_size = '14px'  # Grey color for titles
    margin_between_items = '0.5px'  # Adjust as needed
    border_color = '#C0D6DF'
    background_color = '#C0D6DF'
    padding_between_shapes = '5px'

    # Format conditions with border, padding, and margin, and line breaks
    conditions_formatted = "<br>".join(
        f"<div style='border: 1px solid {border_color}; padding: 5px; margin: {margin_between_items}; background-color: {background_color}; display: inline-block; border-radius: 8px; margin-bottom: {padding_between_shapes};'>{condition}</div>"
        for condition in conditions
    )

    return conditions_formatted


def study_conditions_html(conditions):
    font_size = '14px'  # Grey color for titles

    conditions_formatted = format_conditions(conditions)

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"    .content {{margin-left: 20px;}}"
        f"</style>"
        f"<div class='content'>"
        f"    {conditions_formatted}"
        f"</div>"
    )
    return html_content.encode()


def study_interventions_html(interventions, intervention_type):
    interventions_list = [f'{i_type}: {i}' for i, i_type in zip(interventions, intervention_type)]


    font_size = '14px'  # Grey color for titles
    margin_between_items = '0.5px'  # Adjust as needed
    border_color = '#C0D6DF'
    background_color = '#C0D6DF'
    padding_between_shapes = '5px'
    # Format collaborators with border, padding, and margin, and line breaks

    interventions_formatted = "<br>".join(
        f"<div style='border: 1px solid {border_color}; padding: 5px; margin: {margin_between_items}; background-color: {background_color}; display: inline-block; border-radius: 8px; margin-bottom: {padding_between_shapes};'>{intervention}</div>"
        for intervention in interventions_list
    )

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"    .content {{margin-left: 20px;}}"
        f"</style>"
        f"<div class='content'>"
        f"    {interventions_formatted}"
        f"</div>"
    )
    return html_content.encode()


def age_range_format(minage, maxage):
    return f'{minage} to {maxage} old'


def age_group_format(ages):
    return " ".join(ages)


def study_eligibility_html(sex, ages, healthy_volunteers, criteria):
    font_size = '14px'  # Grey color for titles
    margin_between_items = '10px'  # Adjust as needed
    border_color = '#DBE9EE'
    background_color = '#DBE9EE'
    # Format collaborators with border, padding, and margin, and line breaks
    info_items = [
        {'title': 'Sex', 'value': sex},
        {'title': 'Ages', 'value': ages},
        {'title': 'Healthy Volunteers', 'value': healthy_volunteers}
    ]

    formatted_info = ''.join(
        f"<div style='border: 1px solid {border_color}; padding: 5px; margin: {margin_between_items}; background-color: {background_color}; flex: 1; display: inline-block; border-radius: 8px;'>"
        f"    <strong>{item['title']}:</strong> {item['value']}"
        f"</div>"
        for item in info_items
    )


    # Format criteria with rectangular border and no background
    formatted_criteria = criteria.replace('\n', '<br>')  # Convert line breaks to HTML line breaks
    formatted_criteria = formatted_criteria.replace('* ', '&bull; ')  # Replace * with bullet point

    formatted_criteria = (
        f"<div style='border: 1px solid {border_color}; padding: 5px; margin: {margin_between_items};'>"
        f"    <strong>Criteria</strong><br>"
        f"    {formatted_criteria}"
        f"</div>"
    )

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"    .content {{margin-left: 20px;}}"
        f"</style>"
        f"<div class='content'>"
        f"    {formatted_info}"
        f"    {formatted_criteria}"
        f"</div>"
    )
    return html_content.encode()


def study_arms_html(armgroup_df):

    font_size = '14px'  # Grey color for titles
    margin_between_items = '10px'  # Adjust as needed
    border_color = '#C0D6DF'
    background_color = '#C0D6DF'
    # Format collaborators with border, padding, and margin, and line breaks

    formatted_paragraphs = []

    for index, row in armgroup_df.iterrows():
        # Extract values from the row
        ArmGroup_label = row['ArmGroup_label']
        ArmGroup_type = row['ArmGroup_type']
        ArmGroup_description = row['ArmGroup_description']
        ArmGroup_interventionNames = json.loads(row['ArmGroup_interventionNames'])
        ArmGroup_interventionNames = "<br>".join(ArmGroup_interventionNames)

        # Format the paragraph for the current row
        formatted_paragraph = (
            f"<div style='width: 500px; height: 400px; display: inline-block; margin: {margin_between_items}; vertical-align: top;'>"
            f"    <div style='border: 1px solid {border_color}; padding: 5px; height: 100%; border-radius: 8px;'>"
            f"        <strong>{ArmGroup_label}</strong><br>"
            f"        <div style='border: 1px solid {border_color}; padding: 5px; background-color: {background_color}; display: inline-block; border-radius: 8px;'>{ArmGroup_type}</div><br><br>"
            f"        <strong style='color: grey';>Description</strong><br> {ArmGroup_description}<br><br>"
            f"        <strong style='color: grey';>Interventions</strong><br> {ArmGroup_interventionNames}"
            f"    </div>"
            f"</div>"
        )
        formatted_paragraphs.append(formatted_paragraph)

    # Join the formatted paragraphs together
    arm_group_formatted = "".join(formatted_paragraphs)

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"    .content {{margin-left: 20px;}}"
        f"</style>"
        f"<div class='content'>"
        f"    {arm_group_formatted}"
        f"</div>"
    )
    return html_content.encode()
    
    
def similar_studies_html(similar_studies_df):
    font_size = '14px'  # Grey color for titles
    margin_between_items = '1.5px'  # Adjust as needed
    border_color = '#C0D6DF'
    background_color = '#C0D6DF'
    leadsponsor_color = '#4F6D7A' 
    padding_between_shapes = '5px'
    # Format collaborators with border, padding, and margin, and line breaks
    
    formatted_divs = []

    for index, row in similar_studies_df.iterrows():
        # Extract values from the row
        Study_id = row['Study_id']
        Similarity = row['Similarity']
        Study_title = row['Study_title']
        Study_status = row['Study_status']
        Sponsor_name = row['Sponsor_name']
        Condition = row['MeshTerm_Conditions']
        Scores = row['Enrolment_rate_combined']
        Enrollment_count = row['EnrollmentCount']
        Enrollment_type = row['EnrollmentType']
        
        Conditions = [condition.strip() for condition in Condition.split('.')]

        # Call the status_style function to generate the formatted status box
        formatted_leadsponsor = format_lead_sponsor(Sponsor_name)
        formatted_status = status_style(Study_status)
        formatted_score = score_style(Scores)
        formatted_enrollment = enrollment_type_style(Enrollment_count, Enrollment_type)
        formatted_conditions = format_conditions(Conditions[:1])

        # Format the paragraph for the current row
        formatted_div = (
            f"<div style='width: 500px; height: 400px;display: inline-block; margin: 15px; margin-bottom: 10px; vertical-align: top;'>"
            f"    <div style='border: 1px solid {border_color}; padding: 5px; height: 100%; border-radius: 8px;'>"
            f"        <strong>{Study_title}</strong><br><br>"
            f"        {formatted_leadsponsor}<br>"
            f"        <div style='margin-top: {margin_between_items};'>{formatted_conditions}</div><br>"
            f"        <div style='display: flex; align-items: center; margin-top: {margin_between_items}; justify-content: left;'>"
            f"            <div style='display: inline-block; padding: 5px; color: grey;'>{Study_id}</div>"
            f"            <div style='flex-grow: 1; text-align: center;'>{formatted_status}</div>"
            f"        </div><br>"
            f"        <div style='display: flex; align-items: center; margin-top: {margin_between_items}; justify-content: left;'>"
            f"            <div style='display: inline-block; padding: 5px; color: grey;'>Enrollment Count</div>"
            f"            <div style='flex-grow: 1; text-align: center;'>{formatted_enrollment}</div>"
            f"        </div><br>"
            f"        <div style='display: flex; align-items: center; margin-top: {margin_between_items}; justify-content: left;'>"
            f"            <div style='display: inline-block; padding: 5px; color: grey;'>Enrollment Rate</div>"
            f"            <div style='flex-grow: 1; text-align: center;'>{formatted_score}</div>"
            f"        </div><br>"
            f"    </div>"
            f"</div>"
        )

        formatted_divs.append(formatted_div)

    # Join the formatted divs together
    similar_studies_formatted = "".join(formatted_divs)

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"    .content {{margin-left: 20px;}}"
        f"</style>"
        f"<div class='content'>"
        f"    {similar_studies_formatted}"
        f"</div>"
    )
    return html_content.encode()


def site_name_html(site_name):
    font_size = '20px'
    html_content =(
        f"<meta charset='UTF-8'><style>body {{font-family: 'Source Sans Pro', sans-serif;}} h1 {{font-size: {font_size};}}</style><h1>{site_name}</h1>")
    return html_content.encode()


def site_id_html(site_ids):
    
    font_size = '14px'
    background_color = '#FFFFE0'  # Light yellow
    div_elements = '\n'.join(
        f"<div style='background-color: {background_color}; padding: 5px; border: 1px solid #CCCCCC;'>{site_id}</div>"
        for site_id in site_ids)

    html_content =(
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}" 
        f"    h1 {{font-size: {font_size};}}"
        f"</style>"
        f"<h1>{div_elements}</h1>")
    return html_content.encode()
    

def format_location_box(title, value, border_color, background_color):
    return (
        f"<div class='location-box' style='border: 2px solid {border_color}; background-color: {background_color}; color: white; padding: 5px; margin-bottom: 10px;'>"
        f"    {title}<br>{value}"
        f"</div>"
    )


def site_location_html(city, region, country):
    font_size = '14px'
    border_color = '#4A6FA5'  # Border color for the rectangular border
    background_color = '#4A6FA5'  # Background color for the rectangular border

    html_content = (
        f"<meta charset='UTF-8'>"
        f"<style>"
        f"    body {{font-family: 'Source Sans Pro', sans-serif;}}"
        f"    h1 {{font-size: {font_size};}}"
        f"    .location-box {{border: 2px solid {border_color}; background-color: {background_color}; padding: 5px; margin-bottom: 10px;}}"
        f"</style>"
        f"{format_location_box('City', city, border_color, background_color)}"
        f"{format_location_box('State/Region', region, border_color, background_color)}"
        f"{format_location_box('Country', country, border_color, background_color)}"
    )

    return html_content.encode()


def site_timeline_plot(site_timeline_df):
    site_timeline_df = site_timeline_df.sort_values(by='StartDate')
    
    # Get scatter plot for enrollment count
#     fig_add = px.scatter(
#     site_timeline_df, x='StartDate', y='NCTId', color='Phase', size='EnrollmentCount',
#     color_discrete_sequence=px.colors.qualitative.Set3, opacity=0.7, hover_data=['NCTId', 'EnrollmentCount'])
#     data_add = fig_add['data']
    
    # Get timeline plot as base 
    category_order = ["EARLY_PHASE1", "PHASE1", "PHASE1/ PHASE2", "PHASE2", "PHASE2/ PHASE3", "PHASE3", "PHASE4"]
    
    fig = px.timeline(
        site_timeline_df, x_start='StartDate', x_end='CompletionDate', y='NCTId', color='Phase',
        color_discrete_sequence=px.colors.qualitative.Set3, category_orders={"Phase": category_order},
        hover_data=['NCTId', 'StartDate', 'CompletionDate', 'EnrollmentCount'])
    
#     today = from_datetime_to_dss_string_date(datetime.now())
#     fig.add_vline(x=today, line_dash="dot", line_color="red", annotation_text="Today", annotation_position="top")
    
    fig.update_layout(
        plot_bgcolor='white',  # Set the background color of the plot area
        paper_bgcolor='white'  # Set the background color of the paper (the entire figure)
    )
    fig.update_layout(
        xaxis=dict(
            showline=True,         # Show the x-axis line
            linecolor="black",     # Color of the x-axis line
            linewidth=0.5,
            showgrid=True,         # Show gridlines along the x-axis
            gridcolor="lightgray", # Color of the gridlines# Add this line to show the x-axis line
        ),
        yaxis=dict(
            showline=False,          # Hide the y-axis line
            showticklabels=False))
#     data = fig['data']
#     layout = fig['layout']
    
#     # merge two plots
#     fig = go.Figure(data=data, layout=layout)
#     for trace in data_add:
#         fig.add_trace(trace)
    
    return fig