from typing import List, Optional, Union, Dict
from datetime import datetime
from typing_extensions import TypedDict
from enum import Enum


class UIOptions(TypedDict):
    meshTerms: List[str]
    ntcids: List[str]
    cohortAges: List[str]
    cohortSexes: List[str]


class StudyInfo(TypedDict):
    OfficialTitle: str
    BriefSummary: str
    DetailedDescription: str
    LastUpdatePostDate_parsed: int


class StudyDesign(TypedDict):
    OverallStatus: str
    LastKnownStatus: str
    EnrollmentCount: int
    EnrollmentType: str
    StartDate_parsed: int
    PrimaryCompletionDate_parsed: int
    CompletionDate_parsed: int
    StudyType: str
    Phase: Optional[str]
    LeadSponsorName: str
    LeadSponsorClass: str


class StudyCollaborator(TypedDict):
    Collaborator_name: str


class StudyCondition(TypedDict):
    MeshTerm: str


class StudyIntervention(TypedDict):
    Intervention_name: str
    Intervention_type: str


class StudyEligibility(TypedDict):
    EligibilityCriteria: str
    HealthyVolunteers: Optional[bool]
    Sex: Optional[str]
    MinimumAge: Optional[str]
    MaximumAge: Optional[str]


class StudyArmGroup(TypedDict):
    ArmGroup_interventionNames: Optional[str]
    ArmGroup_description: Optional[str]
    ArmGroup_label: str
    ArmGroup_type: Optional[str]


class StudyScore(TypedDict):
    Enrolment_rate_combined: str


class StudySite(TypedDict):
    Facility_preferred_name: str
    Facility_ID: str
    Site_status: Optional[str]
    Site_City: str
    Site_Region: str
    Site_Country: str
    Location: str
    GeoZip: str


class StudyInvestigators(TypedDict):
    Investigators: str


class StudySummary(TypedDict):
    info: Optional[StudyInfo]
    design: Optional[StudyDesign]
    collaborators: Optional[List[StudyCollaborator]]
    conditions: Optional[List[StudyCondition]]
    interventions: Optional[List[StudyIntervention]]
    eligibility: Optional[StudyEligibility]
    arms: Optional[List[StudyArmGroup]]
    score: Optional[StudyScore]
    sites: Optional[List[StudySite]]
    investigators: Optional[List[StudyInvestigators]]


class NovelStudy(TypedDict):
    title: Optional[Union[str, float]]
    briefSummary: Optional[Union[str, float]]
    cohortAge: List[str]
    cohortSex: Optional[str]
    healthyVolunteers: bool
    inclusionCriteria: Optional[Union[str, float]]
    exclusionCriteria: Optional[Union[str, float]]
    meshConditions: List[str]


class SimilarStudy(TypedDict):
    Study_id: str
    Rank: str
    Similarity: float
    Study_title: str
    Study_status: str
    Sponsor_name: str
    MeshTerm_Conditions: Optional[str]
    Phase: Optional[str]
    EnrollmentCount: int
    EnrollmentType: str
    Enrolment_rate_combined: str


class CandidateSite(TypedDict):
    City: str
    Country: str
    Facility_ID: str
    Facility_preferred_name: str
    GeoZip: str
    Has_competing_studies: bool
    Region_State: str
    Similarity: List[float]
    Study_info: List[List[str]]
    Zip: str


class StudiesSiteMechCond(TypedDict):
    group_mesh_term: str
    prevalence: float


class SiteStudiesTimeline(TypedDict):
    CompletionDate: str
    EnrollmentCount: int
    Facility_ID: str
    Facility_preferred_name: str
    LastKnownStatus: Optional[str]
    LeadSponsorName: Optional[str]
    NCTId: str
    Phase: Optional[str]
    Recruiting: Optional[str]
    StartDate: str
    StudyPeriod: int
    current_study: bool


class SiteStudiesQuarterData(TypedDict):
    CompletionDate: str
    EnrollmentCount: int
    Facility_ID: str
    Facility_preferred_name: str
    LastKnownStatus: Optional[str]
    LeadSponsorName: Optional[str]
    Period: str
    NCTId: str
    Phase: Optional[str]
    Recruiting: Optional[str]
    StartDate: str
    StudyPeriod: int
    current_study: bool


class SponsorSiteData(TypedDict):
    LeadSponsorName: str
    Recruiting: Optional[str]
    count: float


class SiteSdoh(TypedDict):
    County_name: Optional[str]
    Facility_ID: str
    Facility_preferred_name: str
    GeoZip: str
    Percent_Aged_17_and_Younger_county: Optional[float]
    Percent_Aged_65_and_Older_county: Optional[float]
    Percent_Below_150_Poverty_county: Optional[float]
    Percent_Cancer_except_skin_Disease_county: Optional[float]
    Percent_Chronic_Kidney_Disease_county: Optional[float]
    Percent_Civilian_with_a_Disability_county: Optional[float]
    Percent_Coronary_Heart_Disease_county: Optional[float]
    Percent_Covid_Vacc_Primary_Series_Disease_county: Optional[float]
    Percent_Crowding_county: Optional[float]
    Percent_Current_Asthma_Disease_county: Optional[float]
    Percent_Diabetes_Disease_county: Optional[float]
    Percent_English_Language_Proficiency_county: Optional[float]
    Percent_Group_Quarters_county: Optional[float]
    Percent_Housing_Cost_Burden_county: Optional[float]
    Percent_Minority_county: Optional[float]
    Percent_Mobile_Homes_county: Optional[float]
    Percent_Multi_Unit_Structures_county: Optional[float]
    Percent_No_Health_Insurance_county: Optional[float]
    Percent_No_High_School_Diploma_county: Optional[float]
    Percent_No_Vehicle_county: Optional[float]
    Percent_Single_Parent_Households_county: Optional[float]
    Percent_Stroke_Disease_county: Optional[float]
    Percent_Unemployed_county: Optional[float]
    Population_county: Optional[float]
    Site_City: Optional[str]
    Site_Country: Optional[str]
    Social_Vulnerability_Index_county: Optional[float]
    State_name: Optional[str]


class SiteScoreCardModel(TypedDict):
    studies_site_sdoh_on_site: Optional[SiteSdoh]
    studies_mesh_conditions_on_site: List[StudiesSiteMechCond]
    ongoing_studies_timeline_on_site: List[
        SiteStudiesTimeline
    ]  # timeline plot and active studies count
    historical_studies_timeline_on_site: List[SiteStudiesTimeline]
    active_studies_by_quarter_on_site: List[SiteStudiesQuarterData]
    site_used_by_sponsor: List[SponsorSiteData]


class StudyType(Enum):
    protocol = "protocol"
    existing = "existing"


class CohortAge(Enum):
    CHILD = "CHILD"
    ADULT = "ADULT"
    OLDER_ADULT = "OLDER_ADULT"


class SiteScoreCardPostRequest(TypedDict):
    siteId: str
