import {
  Quasar,
  Notify,
  Loading,
  ClosePopup,
  Dialog,
  QIcon,
  QMenu,
  QList,
  QItemSection,
  QItem,
} from "quasar";
import "@quasar/extras/material-icons/material-icons.css";
import "@quasar/extras/material-icons-outlined/material-icons-outlined.css";
import "@quasar/extras/material-icons-round/material-icons-round.css";
import "@quasar/extras/mdi-v6/mdi-v6.css";
import "quasar/src/css/index.sass";
import "quasar-ui-bs/dist/style.css";
import "vite/modulepreload-polyfill";

// Leaflet styles
import "leaflet/dist/leaflet.css";
import "leaflet.markercluster/dist/MarkerCluster.css";
import "leaflet.markercluster/dist/MarkerCluster.Default.css";
import { QuasarBs } from "quasar-ui-bs";
import { myApp } from "./src/index";
import { ServerApi } from "quasar-ui-bs";
import { baseURL } from "./src/api/index";
import { i18n } from "./src/lang/";
import { createPinia } from "pinia";
import { registerDirectives } from "./src/directives/register";

ServerApi.init(baseURL);
myApp.config.unwrapInjectedRef = true;

const pinia = createPinia();
myApp.use(pinia);

myApp.use(i18n);
myApp.use(Quasar, {
  plugins: {
    Notify,
    Loading,
    Dialog
  },
  components: {
    QIcon,
    QMenu,
    QList,
    QItemSection,
    QItem,
  },
  directives: {
    ClosePopup,
  },
});

myApp.use(QuasarBs);

registerDirectives(myApp);


myApp.mount("#app");
