import { createI18n, I18nOptions } from 'vue-i18n';
import enUSBase from './translations/en-US.yaml';
import datetimeFormats from './date-formats.yaml';
import numberFormats from './number-formats.yaml';
import availableLanguages from './available-languages.yaml';


export const i18n = createI18n({
    legacy: false,
	locale: 'en-US',
	fallbackLocale: 'en-US',
    messages: {
		'en-US': enUSBase,
	} as I18nOptions['messages'],
    silentTranslationWarn: true,
    globalInjection: true,
    datetimeFormats,
	numberFormats,
})

export type Language = keyof typeof availableLanguages;

export const loadedLanguages: Language[] = ['en-US'];
