import { i18n, Language, loadedLanguages } from "./index";
import availableLanguages from './available-languages.yaml';
import { loadDateFNSLocale } from "@/utils/get-date-fns-locale";


export async function setLanguage(lang : Language) {

    if (Object.keys(availableLanguages).includes(lang) === false) {
		// eslint-disable-next-line no-console
		console.warn(`"${lang}" is not an available language`);
	} else {
        if (loadedLanguages.includes(lang) === false) {
            try {
                const { default: translations } = await import(`./translations/${lang}.yaml`);
                i18n.global.mergeLocaleMessage(lang, translations);
				loadedLanguages.push(lang);
            } catch (err: any) {
				// eslint-disable-next-line no-console
				console.warn(err);
			}
        }

        i18n.global.locale.value = lang;

		(document.querySelector('html') as HTMLElement).setAttribute('lang', lang);
    }

    try {
        await loadDateFNSLocale(lang); 
    } catch {
        // eslint-disable-next-line no-console
        console.error('Failed loading date locale');
    }

    return true
}