
export interface CandidateSite {
    City:                    string;
    Country:                 string;
    Facility_ID:             string;
    Facility_preferred_name: string;
    GeoZip:                  string;
    Has_competing_studies:   boolean;
    Region_State:            string;
    Similarity:              number[];
    Study_info:              Array<string[]>;
    Zip:                     string;
    [property: string]: any;
}

export enum CohortAge {
    Adult = "ADULT",
    Child = "CHILD",
    OlderAdult = "OLDER_ADULT",
}

export interface NovelStudy {
    briefSummary:      number | null | string;
    cohortAge:         string[];
    cohortSex:         null | string;
    exclusionCriteria: number | null | string;
    healthyVolunteers: boolean;
    inclusionCriteria: number | null | string;
    meshConditions:    string[];
    title:             number | null | string;
    [property: string]: any;
}

export interface SimilarStudy {
    EnrollmentCount:         number;
    EnrollmentType:          string;
    Enrolment_rate_combined: string;
    MeshTerm_Conditions:     null | string;
    Phase:                   null | string;
    Rank:                    string;
    Similarity:              number;
    Sponsor_name:            string;
    Study_id:                string;
    Study_status:            string;
    Study_title:             string;
    [property: string]: any;
}

export interface SiteScoreCardModel {
    active_studies_by_quarter_on_site:   SiteStudiesQuarterData[];
    historical_studies_timeline_on_site: SiteStudiesTimeline[];
    ongoing_studies_timeline_on_site:    SiteStudiesTimeline[];
    site_used_by_sponsor:                SponsorSiteData[];
    studies_mesh_conditions_on_site:     StudiesSiteMechCond[];
    studies_site_sdoh_on_site:           null | SiteSdoh;
    [property: string]: any;
}

export interface SiteStudiesQuarterData {
    CompletionDate:          string;
    current_study:           boolean;
    EnrollmentCount:         number;
    Facility_ID:             string;
    Facility_preferred_name: string;
    LastKnownStatus:         null | string;
    LeadSponsorName:         null | string;
    NCTId:                   string;
    Period:                  string;
    Phase:                   null | string;
    Recruiting:              null | string;
    StartDate:               string;
    StudyPeriod:             number;
    [property: string]: any;
}

export interface SiteStudiesTimeline {
    CompletionDate:          string;
    current_study:           boolean;
    EnrollmentCount:         number;
    Facility_ID:             string;
    Facility_preferred_name: string;
    LastKnownStatus:         null | string;
    LeadSponsorName:         null | string;
    NCTId:                   string;
    Phase:                   null | string;
    Recruiting:              null | string;
    StartDate:               string;
    StudyPeriod:             number;
    [property: string]: any;
}

export interface SponsorSiteData {
    count:           number;
    LeadSponsorName: string;
    Recruiting:      null | string;
    [property: string]: any;
}

export interface StudiesSiteMechCond {
    group_mesh_term: string;
    prevalence:      number;
    [property: string]: any;
}

export interface SiteSdoh {
    County_name:                                      null | string;
    Facility_ID:                                      string;
    Facility_preferred_name:                          string;
    GeoZip:                                           string;
    Percent_Aged_17_and_Younger_county:               number | null;
    Percent_Aged_65_and_Older_county:                 number | null;
    Percent_Below_150_Poverty_county:                 number | null;
    Percent_Cancer_except_skin_Disease_county:        number | null;
    Percent_Chronic_Kidney_Disease_county:            number | null;
    Percent_Civilian_with_a_Disability_county:        number | null;
    Percent_Coronary_Heart_Disease_county:            number | null;
    Percent_Covid_Vacc_Primary_Series_Disease_county: number | null;
    Percent_Crowding_county:                          number | null;
    Percent_Current_Asthma_Disease_county:            number | null;
    Percent_Diabetes_Disease_county:                  number | null;
    Percent_English_Language_Proficiency_county:      number | null;
    Percent_Group_Quarters_county:                    number | null;
    Percent_Housing_Cost_Burden_county:               number | null;
    Percent_Minority_county:                          number | null;
    Percent_Mobile_Homes_county:                      number | null;
    Percent_Multi_Unit_Structures_county:             number | null;
    Percent_No_Health_Insurance_county:               number | null;
    Percent_No_High_School_Diploma_county:            number | null;
    Percent_No_Vehicle_county:                        number | null;
    Percent_Single_Parent_Households_county:          number | null;
    Percent_Stroke_Disease_county:                    number | null;
    Percent_Unemployed_county:                        number | null;
    Population_county:                                number | null;
    Site_City:                                        null | string;
    Site_Country:                                     null | string;
    Social_Vulnerability_Index_county:                number | null;
    State_name:                                       null | string;
    [property: string]: any;
}

export interface SiteScoreCardPostRequest {
    siteId: string;
    [property: string]: any;
}

export interface StudyArmGroup {
    ArmGroup_description:       null | string;
    ArmGroup_interventionNames: null | string;
    ArmGroup_label:             string;
    ArmGroup_type:              null | string;
    [property: string]: any;
}

export interface StudyCollaborator {
    Collaborator_name: string;
    [property: string]: any;
}

export interface StudyCondition {
    MeshTerm: string;
    [property: string]: any;
}

export interface StudyDesign {
    CompletionDate_parsed:        number;
    EnrollmentCount:              number;
    EnrollmentType:               string;
    LastKnownStatus:              string;
    LeadSponsorClass:             string;
    LeadSponsorName:              string;
    OverallStatus:                string;
    Phase:                        null | string;
    PrimaryCompletionDate_parsed: number;
    StartDate_parsed:             number;
    StudyType:                    string;
    [property: string]: any;
}

export interface StudyEligibility {
    EligibilityCriteria: string;
    HealthyVolunteers:   boolean | null;
    MaximumAge:          null | string;
    MinimumAge:          null | string;
    Sex:                 null | string;
    [property: string]: any;
}

export interface StudyInfo {
    BriefSummary:              string;
    DetailedDescription:       string;
    LastUpdatePostDate_parsed: number;
    OfficialTitle:             string;
    [property: string]: any;
}

export interface StudyIntervention {
    Intervention_name: string;
    Intervention_type: string;
    [property: string]: any;
}

export interface StudyInvestigators {
    Investigators: string;
    [property: string]: any;
}

export interface StudyScore {
    Enrolment_rate_combined: string;
    [property: string]: any;
}

export interface StudySite {
    Facility_ID:             string;
    Facility_preferred_name: string;
    GeoZip:                  string;
    Location:                string;
    Site_City:               string;
    Site_Country:            string;
    Site_Region:             string;
    Site_status:             null | string;
    [property: string]: any;
}

export interface StudySummary {
    arms:          StudyArmGroup[] | null;
    collaborators: StudyCollaborator[] | null;
    conditions:    StudyCondition[] | null;
    design:        null | StudyDesign;
    eligibility:   null | StudyEligibility;
    info:          null | StudyInfo;
    interventions: StudyIntervention[] | null;
    investigators: StudyInvestigators[] | null;
    score:         null | StudyScore;
    sites:         StudySite[] | null;
    [property: string]: any;
}

export enum StudyType {
    Existing = "existing",
    Protocol = "protocol",
}

export interface UIOptions {
    cohortAges:  string[];
    cohortSexes: string[];
    meshTerms:   string[];
    ntcids:      string[];
    [property: string]: any;
}
