# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
import requests
import zipfile
import io

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
url = "https://download.geonames.org/export/zip/allCountries.zip"

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
response = requests.get(url)
# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
SCHEMA = [
    "countryCode", "postalCode", "placeName", "adminName1", "adminCode1", "adminName2", "adminCode2",
    "adminName3", "adminCode3", "latitude", "longitude", "accuracy"
]
# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
if response.status_code == 200:
    with zipfile.ZipFile(io.BytesIO(response.content)) as zip_file:
        zip_file_list = zip_file.namelist()
        file_to_extract = zip_file_list[0]
        with zip_file.open(file_to_extract) as file:
            data = pd.read_csv(file, sep="\t", header=0, names=SCHEMA)
else:
    raise Exception('Failed to fetch the ZIP file')
# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE


# Write recipe outputs
countryZip = dataiku.Dataset("countryZip")
countryZip.write_with_schema(data)
