# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
import json
from functools import reduce
import operator
from dataiku import pandasutils as pdu

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Read recipe inputs
design_outcomes_prepared = dataiku.Dataset("design_outcomes_prepared")
design_outcomes_prepared_df = design_outcomes_prepared.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
def get_longest_period(row):
    # zip and impute the time unit and value array.
    time_unit = json.loads(row['time_unit1'])
    time_value = json.loads(row['time_extract'])

    min_len = np.minimum(len(time_unit), len(time_value))
    
    zipped_list = [[float(tu), float(tv)] for tu, tv in zip(time_unit[:min_len], time_value[:min_len])]
    
    if len(time_unit) < len(time_value):
        zipped_list.extend([[float(time_unit[-1]) if time_unit else 0, float(tv)] for tv in time_value[min_len:]])
    elif len(time_value) < len(time_unit):
        zipped_list.extend([[float(tu), float(time_value[-1]) if time_value else 0] for tu in time_unit[min_len:]])
    
    return max_and_multiple(zipped_list)

def max_and_multiple(zipped_list):
    # select the longest combination of period and multiply unit and value.
    if zipped_list:
        max_period = max(zipped_list)
        return reduce(operator.mul, max_period)
    else:
        return 0

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
design_outcomes_prepared_df['Max_TimeFrame'] = design_outcomes_prepared_df.apply(get_longest_period, axis=1)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
design_outcomes_w_duration = dataiku.Dataset("design_outcomes_w_duration")
design_outcomes_w_duration.write_with_schema(design_outcomes_prepared_df)