# Introduction
[Feature Preparation](flow_zone:7yibEts) flow zone implements data cleaning and preliminary feature transformation.

# Recipes & Dataframes
![Screenshot 2023-11-22 at 10.25.35.png](DGgWiAGjukod)

**Outputs**
|   Recipe(s) | Description |   Output Dataset  |
|------------|------------|------------|
|[recipe](recipe:compute_study_descriptions_prepared)|Performs data cleaning|[study_descriptions_prepared](dataset:study_descriptions_prepared)|
|[recipe](recipe:compute_studies_prepared)|Performs data cleaning, date formatting, and text normalization|[studies_prepared](dataset:studies_prepared)|
|[recipe](recipe:compute_overall_officials_w_Index_prepared)|Calculates researcher affiliation count per study|[overall_officials_prepared](dataset:overall_officials_prepared)|
|[recipe](recipe:compute_interventions_by_NCTId)|Pivots intervention type into columns as boolean features|[interventions_by_NCTId](dataset:interventions_by_NCTId)|
|[recipe](recipe:compute_facilities_by_NCTId)|Calculates distinct country count per study|[facilities_by_NCTId](dataset:facilities_by_NCTId)|
|[recipe](recipe:compute_eligibilities_prepared)|Normalizes eligibility age unit into years|[eligibilities_prepared](dataset:eligibilities_prepared)|
|[recipe](recipe:compute_eligibility_text_prepared)|1-1). Splits eligibility criteria into two columns by inclusion and exclusion criteria; 1-2). Normalizes text |[eligibility_text_prepared](dataset:eligibility_text_prepared)|
|[recipe](recipe:compute_designs_copy)|Copies dataframe|[designs_copy](dataset:designs_copy)|
|[prepare_recipe1](recipe:compute_design_outcomes_prepared), [code_recipe2](recipe:compute_design_outcomes_w_duration), [pivot_recipe3](recipe:compute_design_outcomes_w_duration_by_NCTId)|1). Extracts numbers and time units from the 'Outcome_timeFrame' column; 2). Calculates the longest duration by approximation; 3). Pivots outcome types into column and calculates the max time duration |[design_outcomes_w_duration_by_NCTId](dataset:design_outcomes_w_duration_by_NCTId)|
|[recipe](recipe:compute_collaberators_prepared)|Unfolds and unnest arrays|[collaberators_prepared](dataset:collaberators_prepared)|
|[recipe](recipe:compute_browse_conditions_joined_prepared)|1-1). Keeps only root condition Mesh terms; 1-2). Concatenates Mesh terms per study|[browse_conditions_grouped](dataset:browse_conditions_grouped)|


