This Solution doesn't require users to upload any datasets as input. However, it uses data the following sources: 

## Clinicaltrials.gov

[ClinicalTrials.gov](https://clinicaltrials.gov/about-site/about-ctg) is an online database established in 2000 to provide comprehensive information on clinical research studies and their outcomes. It was initially mandated by the Food and Drug Administration Modernization Act of 1997, primarily focusing on investigational drug trials for severe diseases. Over time, it has expanded to encompass a broader range of clinical studies, including observational research.

This resource contains details about each study, including its name, description, sponsors, funding sources, eligibility criteria, interventions, and contact information. Its data schema can be found on the [website](https://clinicaltrials.gov/data-about-studies/study-data-structure). 


## CENSUS / ACS

Accessing and analyzing data related to SDoH measures can broaden the understanding of community health. The [American Community Survey (ACS)](https://www.census.gov/data/developers/data-sets/acs-5year.html) is an ongoing survey that provides vital information about the U.S. population yearly. Detailed population and housing information is published through the U.S. Census Bureau at the geographic level of the state, county, place, census tract, and ZCTA.

Our users can find examples of data in the following categories:
 - [Demographics](https://data.census.gov/cedsci/table?q=DP05&tid=ACSDP5Y2020.DP05)
 - [Social characteristics](https://data.census.gov/cedsci/table?q=DP02&tid=ACSDP5Y2020.DP02)
 - [Economic characteristics](https://data.census.gov/cedsci/table?q=DP03&tid=ACSDP1Y2019.DP03&tp=false)
 - [Housing data](https://data.census.gov/cedsci/table?q=DP04&tid=ACSDP5Y2020.DP04)
 
Note: The ACS provides 5-year "period" estimates that represent data collected over a period of time. The primary advantage of using multiyear estimates is the increased statistical reliability of the data for less populated areas and small population subgroups.

[Notes on ACS annotation values](https://www.census.gov/data/developers/data-sets/acs-1year/notes-on-acs-estimate-and-annotation-values.html)


## Centers for Disease Control and Prevention (CDC)

The [National Center for Chronic Disease Prevention and Health Promotion (NCCDPHP)](https://www.cdc.gov/chronicdisease/index.htm) helps states to collect data on chronic diseases and leading health indicators through a variety of surveillance systems. This information allows the CDC to understand how chronic diseases affect people and places across the United States and how well public health interventions work.

Note: Census Tracts are small, relatively permanent statistical subdivisions of a county or statistically equivalent entity that can be updated by local participants before each decennial census as part of the Census Bureau's Participant Statistical Areas Program (PSAP)


## Geonames
The [reference](https://www.geonames.org/) for zip codes and geopoint for more than 90+ countries. 


## Medical Subject Headings (MeSH) terms
MeSH is a controlled vocabulary thesaurus created and maintained by the National Library of Medicine (NLM) for indexing, cataloging, and searching biomedical literature, particularly in the MEDLINE/PubMed database. The ClinicalTrials.gov registry uses MeSH terms to label and indicate the trial's therapeutic areas and interventions. We downloaded the MeSH table from [here](https://aact.ctti-clinicaltrials.org/data_dictionary).