# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
flop_keywords = dataiku.Dataset("flop_keywords")
flop_keywords_df = flop_keywords.get_dataframe()

flop_keywords_df = flop_keywords_df.rename(columns={"llm_rating_avg": "2. Topic Rating", "keywords": "1. Keyword", "count": "3. # occurences"})

flop_keywords_df["2. Topic Rating"] = flop_keywords_df["2. Topic Rating"].apply(lambda rating:np.round(rating,2))

table = pd.pivot(flop_keywords_df, values=['1. Keyword', "2. Topic Rating","3. # occurences"], index='rownumber',

                       columns=['topic_name']).swaplevel(axis=1)

table.columns = table.columns.map(' | '.join).str.strip('|')
flop_keywords_pivoted_df = table.reindex(sorted(table.columns), axis=1)



# Write recipe outputs
flop_keywords_pivoted = dataiku.Dataset("flop_keywords_pivoted")
flop_keywords_pivoted.write_with_schema(flop_keywords_pivoted_df)
