# How do you use Customer-generated text on a large scale?

The volume of user content available now clearly presents an opportunity to better understand customers and what they like or dislike about products. However, it's always difficult to scale this type of analysis, especially if you want to get into details. Humans are good at understanding complex (sometimes conflicting) information, but even ML can't easily identify the granular topics inside a review.


Here we see an example of a jacket's review:

"The material is velvety smooth, and not quite so pink as pictured on the website. more of a dusty brown rose. well made, nice fit. flattering on my petite frame. a wonderful third piece to complete or elevate an outfit."

We understand that the customers are happy with this product even if the color differs from the one displayed.

[Sentiment Analysis](article:12)
With NLP sentiment analysis, we get a rating of 4/5; the customer is happy but not perfect. It's good to follow the overall satisfaction, but we need to find out what the customer is unhappy about.


# Using LLM

[Topic Modeling with LLM](article:13)
With LLMs, we can get more precise insights. From our analysis of a sample of reviews, we identified five relevant topics:

 - Fit and Sizing
 - Fabric Quality
 - Color Accuracy
 - Design and Style
 - Comfort


[Review Analysis with LLM](article:14)
When we use those topics with a LLM query:

 - Fit and Sizing 5/5:
 
   - Customers are very satisfied with the fit, finding it flattering and well-suited for petite frames.
 
   - Keywords: ["nice fit","flattering","petite frame"]

- Fabric Quality 5/5:
   - The fabric quality is highly praised for its velvety smooth texture, contributing to the overall satisfaction with the product.
 
   - Keywords: ["velvety smooth","well made"]

- Color Accuracy 2/5:
   - There is some dissatisfaction with the color, as it appears more of a dusty brown rose rather than the pink shown on the website.
 
   - Keywords: ["not quite so pink","dusty brown rose"]

- Design and Style 5/5:
   - Customers appreciate the design, considering it a wonderful third piece to complete or elevate an outfit.
 
   - Keywords:  ["wonderful third piece","elevate an outfit"]

- Comfort: 5/5
   - The product is noted for its comfort, enhancing customer satisfaction.
 
   - Keywords: ["velvety smooth"]


Those results catch the specific issue about colors but can still be scaled up using the specific ratings and keywords to monitor a large amount of reviews, as we see in the solution's dashboard:
[Customer Satisfaction Review](dashboard:5hJmVra)