#  Data Input

![data_input_csr.png](DXWpbfPg5CpA)

## Data Schema

|Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| product_id  |unique identifier for a product | string  | "Blouses_8882"  |  yes |
| review_text  | body of the review written by the customer | string  | "This pair of pants is great but the delivery was later than announced :(" |  yes |
| product_category  | category of the revied product | string  | "Jeans"  |  yes |
| review_date  | date of the review | dataiku parsed Date  | "2020-10-11T06:55:54.670Z"  |  yes |
| review_score_provided  | score of the product provided by the user on a scale of 5 | int  | 5  |  yes |
| customer_id  | unique identifier of the customer | string  | "12345"  |  yes |
| customer_country  | country of residence of the customer | string  | "Lithuania"  |  yes |
| customer_latitude  | latitude of a geopoint centered on the customer's country | double  | 36.5748441  |  yes |
| customer_longitude  | longitude of a geopoint centered on the customer's country | double  | 139.2394179  |  yes |


This dataset represent a possible input of preprocessed customer reviews regarding clothing. Customer are spread worldwide.

In this template, all columns are mandatory as they are used later in the dashboards but the key columns needed are:
 - product_id
 - review_text
 
 
During customization, the other columns can be added/removed to match the specific usecase and the available data. Plese be mindfull of the scope of the processing as all reviews will be processed through LLMs.