この記事では、このプロジェクトを使用して、セグメンテーションのインサイトの初期セットを作成するために必要な各ステップを順を追って説明します。入力としてデモデータセットを使用し、設定は[Dataikuアプリケーション](article:11)で行い、[ダッシュボード](article:10)を使用してモデルを理解します。現在ご覧いただいているプロジェクトは完成版で、後述するすべての結果とアウトプットを表示しています。もし、自分のデータを使って独自の分析をしたいのであれば、Dataikuアプリケーションのインスタンスを作成してください。

# データ

このデモプロジェクトでは、シミュレーションされたデータセットを使用しています。詳細はデータモデルをご覧ください。必要なカラムには、データモデルに従って簡単に解釈できる名前が付けられています。また、いくつかの追加のカラムは、独自データのロードを容易にするために、オプションで使用できるように設定されています。

- customer_data：性別（M、F、または不明）、地域（カテゴリとして）。
- additional_information： in_person_interaction (当月の面会回数)、 atm_withrawals (当月の引落とし回数)、 atm_withdrawals_sum (引落とし合計（ドル）)、 physical_services (使用回数)、 physical_services_sum (使用合計（ドル）)、 digital_services (1 (低) ～ 4 (高) の整数、顧客がデジタルサービスに関してどれだけ関与するかを定義)、fx_services (外国為替回数).

シミュレーションデータセットには、1万人の顧客に関する18ヶ月間の情報が含まれています。

このデータセットには、4つの商品タイプと、各タイプ内の様々なサブプロダクトが含まれています。

1. 預金口座。預金口座: 当座預金口座、普通預金口座
2. 無担保融資。無担保貸付：スタンダードクレジットカード、プレミアムクレジットカード、パーソナルローン
3. 有担保貸付。モーゲージ、カーローン、ホームエクイティローン
4. 証券 ダイレクト証券、マネージド証券

# Dataikuアプリケーション

![Optional Columns.png](9L6tuM3Gi4YM)

プロジェクトを実行するために、Dataikuアプリケーションのインスタンスを作成します。このデモでは、シミュレートされたデータセットがすでに接続されているので、最初の2つのセクションでは何も変更しませんが、ここではデータモデルに合うように整形された独自のデータソースを接続することが可能です。3番目のセクションでは、すべての列の識別はすでに正しく、変更する必要はありません。オプションの列のタイルでは、上記のセクションでリストされた列が、複数選択ドロップダウンによって分析に追加されます。このセクションを使用して、分析やデータソースに応じてオプションの列を含めたり除外したりすることができます。次に、Build ボタンを押して、日付データセットを構築します。

![Clustering.png](8ya5S7A8LMBa)

上記の手順が完了したら、Refreshボタンを押下します。基準日ドロップダウンでは、最新の日付（2016-05-28）が選択されています。ルックバック・ウィンドウは月単位で3、クラスタ数は4に設定されています。 これらのオプションは両方とも、異なる結果や洞察を生成するために変更することができます。

プロジェクトのセットアップを完了するためにRunボタンを押すと、Flowが再構築されます。この最終ステップは、私たちのデータセットとハードウェアのセットアップを使用して、10分ほどで完了します。完了すると、計算済みのダッシュボードで強力な分析結果が利用できます。これらは、ポートフォリオ全体に対する洞察を提供し、新しく生成されたセグメントを統合して、さらに理解を深めることができます。

# ダッシュボード

ここでは、[ダッシュボード](dashboard:9J2VUGB)の各スライドを見ながら、その分析からどのようなインサイトが引き出せるかを説明します。

## セグメンテーションモデル

最初のスライドは、セグメンテーション・モデルの概要を示しています。最初は、特定の顧客をその特定のセグメントに関連付けるのに最も明確で影響力のある変数に従って、セグメントに名前が付けられます。これらの名前は、Saved Model インターフェースで独自のカスタムタイトルを入力することで、より短く、よりビジネスに適したものに編集できます（Saved Model インターフェースではなく、ダッシュボードで直接行った変更は、プロジェクト全体では保存されないことに注意してください）。

![Emergents.png](TAKSOkDftu7k)

![Traditionalists.png](0t5XFpyYX0eY)

このプロジェクトでは、シミュレーションデータを使用する際に4つのセグメントを特定し、分析を容易にするために名前を変更しました。

 - Emergents（エマージェント）: 平均より収益が低く、将来的に価値が見込まれる若い顧客。
 - Traditionalists（トラディショナリスト）: 平均より年長の顧客で、低いが安定したエンゲージメントを持つ。
 - Loyalist（ロイヤリスト）: アクティブで価値のある顧客で、多様なポートフォリオを持ち、長期的なエンゲージメントを持つ。
 - Sophisticated（ソフィスティケイト）: 要求の高い顧客で、高い収益を上げるが、不満があれば簡単に解約する可能性がある。
 
このように、リテール・バンキングの分野では、これらのセグメントは珍しいものではありません。興味深いのは、各顧客をこれらのセグメントに割り当てるのに、ビジネスルールは必要なく、完全にデータ駆動型のアプローチを採用している点である。顧客は機械学習によって各セグメントに割り当てられ、その機械学習モデルが使用する基本的なプロセスは、このダッシュボードで利用可能な情報を使用して理解することができます。

我々のデータセットでは、エマージェントとトラディショナリストが顧客ベースの大部分を占めており、他の2つのセグメント（最も価値のあるセグメント）は非常に小さい。

![Heatmap Loyalists.png](wjSKsVtdZn6M)
![Variable Importance.png](Ch0l1hd1Kg9E)

観察、ヒートマップ、変数の重要性のセクションに記載された変数は、様々なセグメントの分離における主要なドライバーでした。これらの分析により、モデルの基本的なロジックを理解し、我々のビジネス知識や洞察と直接比較対照することができます。例えば、このビジュアル分析により、ロイヤリストとソフィスティケイトの違いは、保有する商品の数と種類にあることがわかります。特に、ソフィスティケイトを分ける重要な違いは、証券の利用であり、ロイヤリストは担保付き融資により積極的であることがわかります。

これらは、ビジネスの観点からモデルを理解するための強力なツールであるだけでなく、データサイエンスの観点からも、基礎となるモデルを微調整し、結果を再実行してさらに品質を向上させることを検討する際に有効な手段です。例えば：


- 我々のデータセットでは、顧客年齢とアカウント年齢がセグメンテーションの最も重要なドライバーであり、我々のモデルでは、他の数値変数には対数変換を適用したが、これらの変数には適用していないことが分かっている。もし、これらの変数に対数変換を適用し、モデルを再実行すれば、これらの変数の分散が小さくなり、その結果、セグメンテーションにおけるこれらの変数のウェイトが小さくなります。
- また、数値変数の再尺度化の方法を変更することも可能です。このプロジェクトで使用した標準的な再尺度化（外れ値を保持する）から、最小-最大再尺度化に移行し、これらの変数の影響を軽減することができます。
- 他のセグメントにうまく当てはまらない外れ値を考慮するために、作成されたセグメントの一部が非常に少ないケースを持つ場合、Visual MLインターフェースは、どのセグメントにも属さない外れ値の割合を定義することができます。これは、少数の顧客がどのセグメントにも割り当てられないという結果で、より安定したコヒーレントなモデルをもたらすことができます。

## セグメント分析

セグメント分析のスライドでは、各セグメ ントの構成と金額に焦点をあてています。

![Revenue and Cross Sell.png](FcxpUuchketE)

このスライドから、ロイヤリストの売上高が最も多く、担保付融資商品に大きく依存していることがわかります。次に多いのがソフィスティケート層で、証券商品の比重が高い。トラディショナリストとエマージェンツは収益レベルが低く、エマージェンツは預金口座、トラディショナリストは無担保貸付が主な収益源となっています。クロスセルの面では、トラディショナリストとエマージェンツはクロスセルが少なく、ロイヤリストとソフィスティケイトが少なくとも2種類の商品を保有する傾向が強いという点で共通している。


![Age and Income.png](msf8pR4XeukL)

これらのセグメントは、年齢と収入によって明確に区分されており、この2つの変数がより広い範囲で相関していることから、妥当な結果であると言えます。エマージェンツは若年層と低所得層が多く、トラディショナリストは高齢層と富裕層が最も多いことから、このように名づけられました。

![Product Mixes.png](7JTc8vYNTPaT)

上のグラフは、各セグメントに属する顧客が保有する可能性の高い商品のポートフォーリオを示したものです。トラディショナリストとエマージェントは預金口座のみの保有が多く、ロイヤリストとソフィスティケイトは多様なポートフォリオを持ち、前者は担保付き融資に、後者は証券に傾倒していることが分かります。


![Pivot Tables Segments.png](m4czegc1eKdS)

最後に、ピボットテーブルは、各セグメ ントの構成を示す簡潔な指標を提供し、あるクロスセルのレベル、ティア、またはセグメントから別のセグメントに顧客を「シフ ト」することの潜在的影響を解釈するために使用することができます。

## 階層分析

このスライドは、この例では、銀行が顧客を分類するために使用している既存の分類を表している「層」に焦点を当てます。これらはビジネスルールや他の手法によって駆動され、どの事業部門が顧客を管理し、顧客がどのようなレベルのサービスを受けるかを決定している可能性があります。このダッシュボードに表示される分析は、「新しい」顧客セグメンテーションモデルを必要としないことに注意してください。

このデモのデータセットでは、顧客は3つのカテゴリのいずれかに割り当てられています。

 1. Gold（ゴールド）：銀行にとって最も高いサービスコストに相当するが、顧客一人当たりの収益も最も高い最上位層。
 2. SILVER（シルバー）: 中間のカテゴリーで、コストが低く、潜在的な収益も低い層
 3. BRONZE（ブロンズ）: 最低限のサービスレベル

![Revenue Cross Sell Tier.png](EUj4k9yAalz8)

各階層とも、収益はすべての商品タイプから得られていますが、その比率は若干異なっています。ゴールドの顧客は証券、シルバーは無担保貸付に偏重しており、ブロンズの収益は主に有担保貸付からもたらされていなsy。クロスセルのグラフを見ると、顧客の大半はシルバーまたはブロンズ層に属していますが、総収益はゴールド顧客の方がブロンズ顧客よりも多く、平均してゴールド顧客の方が価値が高いことが分かります。これは、上記の層の定義と一致しています。

![Age Income Tier.png](QkunezrJ8JJn)

年齢との相関はかなり強く、所得との相関はやや弱いようである。いずれの変数も、ブロンズからゴールドになるにつれて、分布はより高い値にシフトしています。

![Product Mix Tier.png](tR7yEa9M5mMK)

商品構成では、ゴールドの顧客はポートフォリオの多様性が高く、シルバーとブロンズの顧客はますます少なくなっている。ブロンズ顧客の90%以上が預金口座のみを保有しているが、シルバーでは70%、ゴールドでは15%未満に減少している。


![Pivot Tables Tier.png](B8f5VtEgT6dF)

このグリッドにより、アナリストはクロスセルと階層が顧客の収益性にどのような影響を与えるかを即座に確認することができます。左の表は、総収益を参照し、収益の最大シェアがどこから来ているかを示しています。一番右の表は、各クロスセルと階層の組み合わせにおける顧客の分布を表しています。これは、中央の表のどのセルを分析的に健全とみなすかを決める際に、結果を「有効」と見なす前に必要なセル内の顧客数のカットオフ値を設定することで役に立ちます。

中央の表では、クロスセルと階層別に、顧客一人あたりに発生する平均収益を評価しています。どの階層であっても、クロスセルによって収益性が向上するという非常に明確なパターンがあります。クロスセルが1の場合は収益が増加し、クロスセルが2の場合は階層がゴールドに近づくほど収益が減少しますが、クロスセルが3の場合は単調なパターンが見られません。特に、クロスセルが1より大きいブロンズ顧客は潜在的に非常に価値が高いため、ブロンズ顧客への投資を増やすことは理にかなっている可能性があります。これは、機械学習を使用しない場合でも、Dataikuが既存の顧客セグメンテーションアプローチをデータ駆動で改善する取り組みを支援することができる優れた例です。


## セグメントと階層

次のスライドでは、セグメントとティアを比較し、両者の関連性を理解します。

![Customer Count Repartition.png](BzvVw5jhLlnu)

左側のグラフから、ゴールド顧客にはソフィスティケイトの顧客が多く、次にロイヤリストとトラディショナリスト、そしてエマージェントはごく少数であることがわかります。これは、このセグメントの定義通りの結果となっています。一方、ブロンズ顧客は、ほぼエマージェンツのみで構成され、他のセグメントはほとんどなく、ソフィスティケートの顧客はほとんどいません。そして、シルバーの顧客は、トラディショナリストの割合が多く、次にエマージェント、ロイヤリスト、ソフィスティケイトの順になっています。

右側のグラフは、少し違う視点からのものですが、同じデータが表示されています。そして、ゴールドを最も重視し、ブロンズを最も軽視するセグメントから始まり、最も獲得が少ないセグメントで終わるという順序にすることができます。

 1. Sophisticated（ソフィスティケイト）
 2. Loyalist（ロイヤリスト
 3. Traditionalists（トラディショナリスト）
 4. Emergents（エマージェント）
 
 ![Revenue Share Repartition.png](bOAeEYEgDelx)
 
収益の内訳を見ると、まず、階層別の内訳は上記と大きく異なりますが、セグメント別の内訳は、顧客数の内訳と類似しているように見えます。各階層とも、収益の大半はロイヤリストからであり、ソフィスティケートの顧客からも若干の収益が得られている。これは、平均して、1つのセグメント内では、各顧客は階層に関係なく同じ収益を上げることを意味します。このように、セグメントは、最も価値のある顧客と最も価値のない顧客を、ティアよりもよく識別することができます。
 
 ![Pivot Table Segment Tier.png](j0RPqM776Y5a)

最後に、ピボットテーブルを使って、上記のグラフの背後にある実際の数字を見ることができます。収益の大部分はロイヤリスト、特にシルバー会員によるものですが、各セグメント内ではシルバー会員の平均収益は低くなっています。また、顧客層別の平均収益は、セグメント内ではあまり変化しませんが、層内ではセグメントによって大きく変化しており、先のグラフで示された結論を裏付けています。

## セグメントの推移

最後のスライドは、セグメンテーションの推移を見るものです。

![Stability Segment.png](QAMV0jq2eXYu)

安定性グラフは、特定のクライアントが1ヶ月後、または基準期間（この例では3ヶ月に設定）後も同じセグメントに留まる可能性を表示します。参照期間は基準期間の「1ヶ月」よりも長いので、低くなっていることがわかります。セグメントを比較すると、最も安定しているのはトラディショナリストとロイヤリスト、最も安定していないのはソフィスティケイトという結論になり、私たちの予想と一致しています。

![Transition Segment.png](GKf6nxQ3z1O3)

Sankey Chartは、あるセグメントから別のセグメントへの時間的な遷移を表しています。1つ目は単月の推移、2つ目は基準期間（この例では3ヶ月）の推移をプロットしています。どちらも同じようなパターンを示しています。新規顧客にとって出発点となりやすい「Emergence」セグメントから始めると、もちろん同じセグメント内にとどまるのが最も一般的な結果です（上記の「Stability」チャートを参照）。しかし、次に多いのはトラディショナリストセグメントへの移行で、ロイヤリストに直接移行する割合は少なく、ソフィスティケイトに移行する割合はさらに少なくなっています。なお、リンクの幅は、移動した顧客を移動元のセグメントに属する顧客で割った比率に比例するため、顧客数の点では直接比較することはできない。

トラディショナリスト（グラフのセグメント名をクリックすると表示されます）は、上記の安定性チャートに基づくと非常に安定したセグメントであり、他のセグメントの大きなシェアが（左から）入ってきて、他のセグメントに（右から）去るセットははるかに少なく、セグメント間で比較的同じ割合であることがわかります。ロイヤリストセグメントも同様のパターンを示していますが、流入遷移は少なく、流出遷移はトラディショナリストに集中し、ソフィスティケートされたセグメントはそれほどでもありません。ソフィスティケートされた人々は、アウトカミングトランジションの割合が高く、トラディショナリストやロイヤリストへの移行も頻繁に行われています。

![Historical Evolution Segment.png](nZPvhrnBZBIx)

最後の3つのグラフは、顧客数、総売上高、顧客一人当たりの平均売上高という3つの主要指標の時系列をセグメント別に示したものです。これらのグラフから、セグメント構成の変化と傾向を評価し、マーケティングやその他の取り組みが測定可能な影響を及ぼしているかどうかを確認することができます。いくつかの観察ができます。

 -  2015年5月に多くの顧客がEmergenceからTraditionalistに移動したようですが、おそらく注目すべきイベントやキャンペーンがあったのでしょう。
 - エマージェンツを除くすべてのセグメントからの総収益は、全期間にわたって大幅に増加しました（ロイヤリストでは30％、ソフィスティケイトでは70％の間）。おそらく、これは戦略的な再評価が必要であることを示唆しているのでしょう。
 - 顧客一人当たりの平均売上は、2015年6月にソフィスティケイトとロイヤリストが顕著に増加したが、それ以外は極めて安定した値を維持しています

