[教師なし学習（クラスタリング）](https://en.wikipedia.org/wiki/Unsupervised_learning)は、機械学習の一種で、ラベル付けされていないデータからパターンを見つけようとするものです。「ラベルなし」とは、各顧客がどのクラスタに属するべきかについての「真の」または「既知の」値が提供されていることを意味します。教師なし学習アルゴリズムは、統計的に類似しているデータをグループ化しようとします。Dataikuでクラスタリングは、[Visual ML](https://doc.dataiku.com/dss/latest/machine-learning/unsupervised/index.html)を使用することにより、コードを一切書かずにDataikuで実現することができます。このアプローチにより、このプロジェクトは純粋にデータ指向の顧客セグメンテーションを行います。

# K-Means クラスタリング

クラスタリングのための最も一般的なアルゴリズムの1つは、[K-meansクラスタリング](https://en.wikipedia.org/wiki/K-means_clustering)です。このアルゴリズムでは、ユーザーがベストプラクティスや、妥当とされるクラスタ数の情報に基づき、希望するクラスタ数を設定し、その後、その数のクラスタを見つけるために最適化が実行されます。このアルゴリズムは、収束するまで以下の2つのステップを順次実行し、繰り返し動作するものと考えられます。最初に、いくつかの手段が各クラスタについて定義され、そして。

- 割り当て：各観測値（データ）は、最も近い平均に関連するクラスタに割り当てられる。
- 更新：クラスタのそれぞれの平均を再計算する。

アルゴリズムは局所最適に陥るかもしれず、その結果、あまり有用でない出力になるかもしれませんが、通常は、迅速で賢明な結果をもたらします。クラスタの数を変えたり、入力変数を変えてみたり、自由に試してみてください。


# クラスター分析

クラスタリング問題のパフォーマンスメトリクスは、比較対象となる真の値がないため、予測タスクのように単純ではありません。したがって、クラスタリングの品質とセンスを評価するために、ビジネスの専門知識を持ち込む必要があります。

