_This article is targeted at end-users of the Demand Forecast application._

The [Demand Explorer](dashboard:jrsMSKr) is an interactive dashboard that lets business users visually assess and validate sales forecasts, compare them with past performance or legacy methods, and ensure forecast quality before making operational decisions.

![Demand Explorer.png](etA8o2o8rp0A)

# Time Series Visualization

The main chart shows **actual sales** and **forecasted values** over time. If a **legacy forecast** was provided during setup, it is also displayed for comparison.

Below the chart, a **pivot table** provides a detailed view:

- Each row shows sales, forecasts, and forecast errors.
- Each column corresponds to a time step (e.g. a month).
- Data is grouped by the first Time Series Identifier (TSID #1, e.g. _store_) and then by TSID #2 (e.g. _item_).

On the left, **filters** allow you to:

- Focus on specific items, stores, or combinations.
- Explore one store across all items or one item across all stores.
- A date range filter is also available. By default, the dashboard shows:
  - Two horizons of historical data (for context)
  - One horizon of future forecasts

# Validate the Forecasting Method (Backtest Period)

The Time Series Chart quickly shows periods where forecasts (new or legacy) diverge from actuals: this enables a 1st round of "visual validation" of forecast accuracy, and to pinpoint areas to further investigate.

In addition to the forecast error over the whole backtest period, the Pivot Table helps review error per time step, to ensure that the new forecast is consistently under a given threshold at every time step, or consistently better than the legacy approach. Depending on the cardinality of TSIDs, this validation can be done:

- Per scope for all products
- Per product for all scopes
- Per product and per scope

![Pivot Table.png](FgGqkWoFwLZ2)

# Validate Forecasts Before Decisions (Future Period)

The Time Series Chart helps make sure that forecasts on future time steps make visual sense in continuation of the last observations, that they align with recent sales/consumption trends and historical patterns.

Before using forecasts for decisions (inventory, procurement, staffing), also validate...

- The sum of forecasted values over the whole horizon; this can be found in the "Grand Total" column of the Pivot Table, in the "Sum of forecast" rows (these rows are all 0 outside the future horizon).
- Forecasts at each time step in the future. Granular values can be found in the last H columns of the Pivot Table, corresponding to a horizon of H future time steps.
