##  Overview

This solution includes two scenarios that orchestrate the demand forecasting flow. They automate key steps such as dataset preparation, model training, scoring, and dashboard updates.
By dynamically adapting to the selections made in the Project Setup, these scenarios ensure consistency and reproducibility across runs.

## Scenario: Connect, Build, Train & Deploy

This scenario automates the end-to-end process of generating a demand forecast based on the configuration defined in the Project Setup.

### Key Steps:

1. **Dataset Connection & Sharing**  
   Shares the selected input datasets from the preparation project (e.g., sales, pricing, legacy forecast) and connects them to the current flow. Sync recipes are created if needed, and unnecessary datasets from previous runs are unshared.

2. **Connection & Engine Alignment**  
   Adapts all datasets and recipes to use the appropriate connection and execution engine, based on the selected dataset.

3. **Input Data Build**  
   Builds the main input dataset for forecasting (`input_demand_data`), ensuring it's ready for training.

4. **Optional Pricing Integration**  
   If a pricing dataset is selected, it is joined to the input data, and a `discount_pct` column is computed automatically.

5. **Forecast Horizon & Time Configuration**  
   Infers the time step (daily, weekly, or monthly) and determines the cut-off date for model training. This defines the split between training and forecast periods.

6. **Model Training & Selection**  
   Trains multiple time series models (e.g., DeepAR, Prophet) using the prepared training dataset. The best-performing model is selected based on the optimization metric and automatically deployed.

7. **Forecast & Backtest Generation**  
   Runs scoring recipes to generate both:
   - **Forecasts** for future periods
   - **Backtest results** to evaluate historical accuracy

8. **Data Preparation for Visualization**  
   Applies transformations (window and prepare recipes) to align forecasts and historical data, enabling side-by-side comparison.

9. **Final Join & Metrics Computation**  
   Joins all relevant outputs, including forecasts, backtest, and legacy forecasts if applicable, and computes forecast error metrics such as `abs_relative_error`.

10. **Dashboard Update**  
    Updates the Demand Explorer dashboard:
    - Configures chart axes and measures
    - Applies time filters based on the forecast horizon
    - Updates filter menus based on selected time series identifiers

---

This scenario is designed to be fully automated — it can be re-run safely after updates to input data or project configuration.

## Scenario: Rescoring

This scenario allows users to update the forecast **without retraining the model**.

It rebuilds the entire flow using the currently deployed model to generate:
- **Updated forecasts** based on the latest available input data
- **Backtest results** 
- Refreshed **dashboard visualizations**

This is the scenario to use when **new data is regularly ingested**, and you simply want to **update the dashboard and forecasts** without modifying the model configuration or retraining.