Project's datasources are showcased in the [inputs_zone](flow_zone:E5kZMPY).
[See more information on the inputs_zone](article:21).

# Datasets specific
- [locations_dataset](dataset:locations_dataset): 
 
   - **Dataset Granularity**: 1 row = 1 single location. 
   - Requirements: The dataset should have at least 1 key (1 column or a column combination) allowing to identify each single location. 
   - Dataset can contain as many columns as you want.
     - All  **categorical**  columns will be used to enrich the [webapp's](web_app:43AlXZt) locations filtering sections.
 

- [customers_dataset](dataset:customers_dataset): 

  - **Dataset Granularity**:  1 row = 1 customer
  - Requirements: The dataset should have a single column allowing to identify each customer. It should be exactly named ***customer_id***.
   - Dataset can contain as many columns as you want.
     - All  **categorical**  columns will be used to enrich the [webapp's](web_app:43AlXZt) customers filtering sections.  
 
# General requirements

For both datasets, each location must be related to: 

- Two latitude and longitude columns, exactly named ***latitude*** and ***longitude*** .
- A single address column, exactly named ***address***: In that case, the plugin recipes  [compute_locations_geocoded](recipe:compute_locations_geocoded) (locations case) and [compute_customers_geocoded](recipe:compute_customers_geocoded) (customers case) will geocode your the addresses.

  - Note 1: The plugin recipe is configured to work by default with the OpenStreetMap API provider. If you have access to another geocoding API provider, you can modify the [flow's plugin recipe](recipe:compute_locations_geocoded). 
  
  See the plugin documentation: https://www.dataiku.com/product/plugins/geocoder/ . 
     
  - Note 2: Geocoding can be imprecise or fail depending on both the quality and the precision of your addresses.
  Prefer starting the project with your locations exact latitudes and longitudes if you have it.