This case study offers a walkthrough of the solution using 100 stores from the east of France and 7500 artificially created customers . 

## User Story

Users can leverage Distribution Spatial Footprint to identify the catchment area of each store, their proximity to other stores and how many customers are within a given time range. Through the Project Setup, they can configure the input date and how to evaluate the [isochrones](article:3). 

## Data

The store dataset is build from 100 store location in the east of france recovered from public data.

![store_location.png](z3jmNVoCIVd3)

A sample of 7500 customer randomly distributed in the same area has been created to immitate a dataset of customers personal informations.

![customer_location.png](mo5Cpil3fIxG)


In both datasets, location can be provided as written adresses (that have to be parsed with geocoding) or directly with longitude/latitudes.

## Insights

![dsf_isochrones_setup.png](dcCWrYBZIcM0)

Computing the isochrone around each location allows you to evaluate the true time distance from each location. You can then evaluate is a given store is isolated compared to the competition or if it's in a competitive area.

![competitors_count.png](csSe9ytWuiKF)

If customer data is used, you can evaluate the catchment area from each location.

![customer_count.png](K60rRYCoqbeZ)

Some extra metrics are can be computed like the isochrones areas as presented in the [related section](article:39) of the project setup.

The use of isochrone is more accurate the direct distance as it takes infrastructure into account (i.e. roads will increase the area covered by a store if we use car as a means of transportation but might reduce the area for walking customers).

Here we see an example of the isochrones build using car transportation (notice the impact of main roads):
![isochrone_car.png](YfmENFddYaMX)

and the same store with walking:

![isochrone_walking.png](eMJ3kHExafa7)


Combining both informations can show you how many customers live in the catchment area of a given store:

![customer_analysis.png](woVCCLqcknE9)

