<span id="version" style="color: grey; float: right">Version 1.0.0</span><br/>

# Agents and LLM In Retail:  Dynamic Selling Assistant
A conversational agent powered by centralized store data and transaction information that efficiently accesses various sources of information and gets synthetic results regarding the management of sales in a retail context.

## Industry Challenge
Regional Sales Managers want to **minimize unsold stocks** through the right markdown strategy while ensuring stores **don’t run out of in-demand products** to maximize revenues. 
Their decision making rests on a large variety of siloed data points and models which acts as a barrier to reactivity and consistency in sales strategy. 

Success can hinge on multiple factors:
- Proper inventory level optimization to minimize unsold stock
- Optimal pricing strategies for different product categories
- Store-level product availability to prevent stockouts of popular items

## Agent Value
We harness the power of Agent Hub, to seamlessly integrate and orchestrate multiple sub-agents. These agents extract rich insights from centralized store data and augment it with demand forecasting of products from the [Demand Forecast](https://knowledge.dataiku.com/latest/solutions/retail/solution-demand-forecast.html) solution, simulation of the impact of a Markdown using the [Markdown Optimization](https://knowledge.dataiku.com/latest/solutions/retail/solution-markdown-optimization.html) solution and recomendations using [Product Recommendation](https://knowledge.dataiku.com/latest/solutions/retail/solution-product-recommendation.html) .

The web app provides a chatbot interface for regional managers to interact directly with the agents using natural language, allowing them access to guidance related to:
- Informed inventory management and pricing decisions -- Real-time analysis of supply situations and inventory levels
- Comprehensive sales landscape understanding and access -- Competitive intelligence on product performance, cross-selling opportunities
- Immediate insights on historical or active store performance -- Help identify optimal inventory levels and pricing adjustments -- Informed product selection and promotion strategies

## Projects Highlights
- Built on top of of the insights from the [Demand Forecast](https://knowledge.dataiku.com/latest/solutions/retail/solution-demand-forecast.html), [Markdown Optimization](https://knowledge.dataiku.com/latest/solutions/retail/solution-markdown-optimization.html), [Product Recommendation](https://knowledge.dataiku.com/latest/solutions/retail/solution-product-recommendation.html), [Customer lifetime Value](project:SOL_CLV_FORECAST)
- Created with Agent Hub and Agent Builder
- Regional Sales Manager Assistant Webapp: an agent designed to optimize inventory management and preempt shortages
