def get_header_h2_style():
    return {
        'fontSize': '16px',
        'fontWeight': 400,
        'font-family': 'Helvetica Neue',
     }
def get_subheader_style():
    return {
        'fontSize': '14px',
        'fontWeight': 400,
        'font-family': 'Helvetica Neue',
    }

def get_div_message_style():
    return {
        'fontSize': '12px',
        'fontWeight': 400,
        'color': 'black', 
        'font-family': 'Helvetica Neue'   
    }    


def get_tab_style():
    return {
        'font-size': '17px',
        'width': '300px',
        'background-color': 'white',
        'textAlign': 'left',
        'color': 'black',
        'margin': '4px',
        'padding': '8px 12px',
        'font-weight': 'normal',
        'box-shadow': 'none',
        'cursor': 'pointer'
    }

def get_tab_selected_style():
    return {
        'font-size': '17px',
        'width': '300px',
        'border': "1px solid #666666",
        'border-radius': '0',
        'background-color': 'white',
        'textAlign': 'left',
        'color': 'black',
        'font-weight': 'bold',
        'margin': '4px',
        'padding': '8px 12px',
        'cursor': 'pointer'
    }


def get_description_style():
    return {
        'width': '100%', 
        'height': '100px',
        'fontSize': '12px',
        'backgroundColor': '#f9f9f9',  
        'border': 'thin solid lightgrey',  
        'color': '#3e3e3e',
        'font-family': 'Helvetica Neue',
        'font-weight': 400
    }

def get_tooltip_style():
    return {
        'background-color': '#333',  
        'color': '#fff', 
        'padding': '5px', 
        'border-radius': '4px',  
        'box-shadow': '0px 2px 4px rgba(0, 0, 0, 0.1)',  
        'font-size': '12px', 
        'line-height': '1.2', 
        'width': '200px',  
        'text-align': 'center' 
    }

def get_question_mark_style():
    return {
        'cursor': 'pointer',
        'background-color': 'black', 
        'color': 'white',  
        'border-radius': '50%', 
        'display': 'inline-block',  
        'width': '20px',  
        'height': '20px',  
        'text-align': 'center',  
        'line-height': '20px', 
        'font-size': '14px', 
        'margin-left': '8px' 
            }

def get_left_tab_label_hidden_style():
    return {
        'display': 'none', 
        'padding': '0'
            }

def get_table_styles():
    return {
        'style_table': {
            'width': '100%',
            'overflowX': 'scroll',
            'border': 'thin lightgrey solid',
            'borderRadius': '8px',
            'padding': '5px',
            'box-shadow': '2px 2px 8px rgba(0, 0, 0, 0.1)',
        },
        'style_header': {
            'backgroundColor': '#2B66FF',
            'fontWeight': 'bold',
            'color': 'white',
            'textAlign': 'center',
            'fontSize': '12px',
            'borderBottom': '2px solid #3e3e3e',
        },
        'style_cell': {
            'padding': '8px',
            'textAlign': 'left',
            'backgroundColor': '#f9f9f9',
            'border': 'thin solid lightgrey',
            'fontSize': '10px',
            'color': '#3e3e3e',
            'whiteSpace': 'normal',
        },
        'style_data_conditional': [
            {
                'if': {'row_index': 'odd'},
                'backgroundColor': '#f5f5f5',
            },
            {
                'if': {'state': 'selected'},
                'backgroundColor': 'rgba(255, 218, 185, 0.6)',
                'border': '1px solid orange',
            },
            {
                'if': {'column_id': 'important_column'},
                'backgroundColor': '#FFD700',
                'color': 'black',
                'fontWeight': 'bold',
            },
            {
                'if': {'row_index': 'hovered'},
                'backgroundColor': '#f0f0f0',
                'cursor': 'pointer',
            },
            {
                'if': {'column_id': 'cluster'},
                'backgroundColor': '#D6EAF8',  # Light blue
                'fontWeight': 'bold',
                'border': '1px solid #999',
            }
        ],
        'style_as_list_view': True,
    }


def get_button_style(): 
    return {
        'margin-top': 0,
        'margin-bottom': '1px',
        'margin-left': '2px',
        'text-transform': 'uppercase',
        'font-size': '12px',
        'font-weight': '500',
        'font-style': 'normal',
        'padding': '3px 8px',
        'line-height': '16.34px',
        'background': 'white',
        'color': '#2D86FB',
        'border': '1px solid #2D86FB',
        'border-radius': '0',
        'cursor': 'pointer'
           }


def get_enter_box_style():
    return {
        'width': '100%', 
        'fontSize': '12px',
        'backgroundColor': '#f9f9f9',  
        'border': 'thin solid lightgrey',  
        'color': '#3e3e3e',
        'height': '20px' 
                    }

def get_dropdown_style():
    return {
        'width': '100%', 
        'fontSize': '12px',
        'backgroundColor': '#f9f9f9',  
        'border': 'thin solid lightgrey',  
        'color': '#3e3e3e' ,
        'cursor': 'pointer'
                  }


def get_card_style():
    return{
    'border': '1px solid #ddd',  # Use the same border size in both styles
    'border-radius': '10px',
    'background-color': '#fff',
    'box-shadow': '0 2px 4px rgba(0, 0, 0, 0.1)',
    'margin': '5px 0',  # Keep margin and padding consistent across both states
    'padding': '5px',
    'width': '100%',
    'box-sizing': 'border-box',  # Ensure border size does not affect element size
    #'display': 'flex',
    #'flex-direction': 'column',
    'justify-content': 'center',
    'align-items': 'center',
    'font-family': 'Helvetica Neue',
    'font-weight': 400,
    'font-size': '12px',
    'text-align': 'center',
    'line-height': '1.2',
    'cursor': 'pointer',
    
}

def get_selected_card_style():
    return{
    'border': '2px solid blue',  # Same border size, but different color
    'border-radius': '10px',
    'background-color': '#fff',
    'box-shadow': '0 2px 4px rgba(0, 0, 0, 0.1)',
    'margin': '5px 0',  # Same margin and padding
    'padding': '5px',
    'width': '100%',
    'box-sizing': 'border-box',
    #'display': 'flex',
    #'flex-direction': 'column',
    'justify-content': 'center',
    'align-items': 'center',
    'font-family': 'Helvetica Neue',
    'font-weight': 400,
    'font-size': '12px',
    'text-align': 'center',
    'line-height': '1.2',
    'cursor': 'pointer',
    
}

def get_visible_tab_style():
    return {
        'border': 'none', 
        'background': 'none',  
        'padding': '10px', 
        'fontSize': '18px', 
        'fontWeight': 400,  
        'textAlign': 'left',  
        'color': '#333',  
        'marginLeft': '-20px', 
        #'marginTop': '-20px' 
    }

def get_left_panel_style():
    return {
        'width': '22%',
        'height': '100vh',  # Fix the height
        'display': 'inline-block',
        'padding': '20px',
        'backgroundColor': 'white',
        'overflowY': 'auto',  # Scroll instead of grow
        'boxSizing': 'border-box',
        'borderRight': '1px solid #ccc'
    }

def get_right_panel_style():
    return {
        'width': '78%',
        'height': '100vh',  # Already good
        'display': 'inline-block',
        'padding': '20px',
        'verticalAlign': 'top',
        'borderLeft': '1px solid #ccc',
        'overflowY': 'auto',
        'boxSizing': 'border-box',
        'position': 'relative'
    }

def get_main_style():
    return {
        'fontFamily': 'Helvetica Neue',
        'fontWeight': 400,
        'display': 'flex',
        'flexDirection': 'row',
        'width': '100vw',
        'overflow': 'hidden'
    }


def get_message_style():
    return {
                'fontSize': '12px',
                'fontWeight': '400',
                'fontFamily': 'Helvetica Neue',
                'color': 'black',
                'marginTop': '10px'
            }

def get_refresh_button_style():
    return {
    'position': 'fixed',
    'top': '10px',
    'right': '10px',
    'zIndex': 999,
    'background-color': 'white',
    'border': '1px solid #ccc',
    'padding': '6px',
    'border-radius': '6px',
    'box-shadow': '0 2px 4px rgba(0,0,0,0.1)'
}


