# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Dataiku setup
client = dataiku.api_client()
project = client.get_default_project()

# Create datasets
rule_based_bounds_df = pd.DataFrame(columns=['session_name', 'bounds', 'weights'])
metadata_dataset_df = pd.DataFrame({
    'session_name': [],
    'segmentation_version': [],
    'status': [],
    'original_dataset': [],
    'username': [],
    'datetime': pd.to_datetime([]),  # Ensuring 'datetime' column has the correct datetime format
    'method': [],
    'description': [],
    'specifications': [],
    'selected_features': [],
    'cluster_name_remap': []
})

# Write recipe outputs
rule_based_specs_dataset = dataiku.Dataset("rule_based_specs_dataset")
rule_based_specs_dataset.write_with_schema(rule_based_bounds_df)
metadata_dataset = dataiku.Dataset("metadata_dataset")
metadata_dataset.write_with_schema(metadata_dataset_df)

output_data_folder = dataiku.Folder("YIM9iOet")
output_data_folder_info = output_data_folder.get_info()

model_sessions_folder = dataiku.Folder("TdqwWquP")
model_sessions_folder_info = model_sessions_folder.get_info()

segmentation_versions_folder = dataiku.Folder("SyyDkxtP")
segmentation_versions_folder_info = segmentation_versions_folder.get_info()

compare_sessions = dataiku.Folder("LvSKpnPJ")
compare_sessions_info = compare_sessions.get_info()

# Scenario to clean folders
scenario = project.get_scenario("CLEAR_FOLDERS")
scenario.run_and_wait()
