<span id="version" style="color: grey; float: right">Version 1.2.0</span>

# Dynamic Segmentation

In recent years, more than a third of commercial drug launches fail to meet market expectations, with large global pharmaceutical organizations trailing behind both small and midsize companies with only a 61% launch performance success rate. Key factors revolve around  **inadequate market access or understanding of market needs, and the inability to prove product differentiation** .  With increasing competitive intensity in the healthcare market, pharmaceutical organizations are tasked to optimize their commercial operations to make the most efficient use of their sales and marketing resources.

In order to engage more effectively with healthcare professionals as new medications and therapies are commercialized, teams are turning to data-driven, tailored customer segmentation and precision targeting to both better allocate their sales teams and their marketing campaign design and spend.  

![2.png](SfpILLgqF6Le)
![3.png](20pjuhh4Eizw)
 **Key challenges that precision targeting through customer or HCP segmentation can address include:** 
 - Declining effectiveness of traditional sales rep activities
 - Limited marketing budget with an increasing number of potential channels
 - Complex prescriber behaviors and preferences
 - Finding key opinion leaders that influence market receptiveness to new therapies
 - Varying HCP receptivity to different communication channels

A sales and/or marketing manager needs to be able to take varied sources of customer or HCP information, such as reach, frequency, prescribing behaviors, addressable patient populations, recent engagement activity, in a multifaceted approach to create various segments for precision targeting and resource allocation. As these behaviors/factors are continually changing in a dynamic healthcare market, the segments created based on various marketing or sales programs need to be fluid, not fixed.  As new data comes in, segments must be updated to reflect this fluidity over time.  Finally, as different HCP segments for different purposes are created and updated, it's critical to compare how HCPs are segmented or targeted across different segmentation approaches. 

 **The Dynamic Segmentation Solution provides a web application framework to create, manage, and compare various data-driven HCP segments that are dynamically updated with ongoing data collection.** 

 # Key Highlights 
 - Create  **data-driven HCP segments via rules-based or machine-learning methodologies** to improve sales allocation and marketing effectiveness
 - Maintain and  **update fit-for-purpose segmentations across time**  to accommodate changing dynamics in HCP behaviors, sales initiatives, and marketing campaign outreach
 - Compare and  **contrast different segmentations in multi-faceted commercial efforts**  across your brand portfolio
 - Export segments and further explore trends across or within segments and  **build rich HCP profile data sets**  to feed into omnichannel or next-best initiatives
 - Extend the application of Dynamic Segmentation beyond provider-level segments with a  **fully flexible data model** 

# Business Value

A successful implementation of precision targeting via dynamic segmentation can:
 - Increase overall prescription volume for commercial brand success
 - Improve sales rep efficiency and engagement
 - Reduce marketing spend waste on ineffective activities
 - Increase digital engagement and suitability of tailored or custom content for HCP satisfaction
