# Multi Segmentation Explorer
The [Multi Segmentation Explorer](web_app:vJbijSD) web application allows users to compare and analyze multiple segmentation sessions easily. Users can search and select relevant sessions, view the combined data side by side, and export the results for further exploration in Dataiku.
This tool simplifies the process of tracking changes or differences in segmentations across sessions, making it easy to identify how segments have evolved over time. The integration with Dataiku ensures that data remains consistent and accessible, and the export feature provides flexibility to extend analysis beyond the app.

![8.png](jnWRfCG9emUM)
## Left Panel - Selection of Sessions
- Search and Filter: Users can search for specific segmentation sessions using a search bar. This helps filter through available sessions quickly.
- Each session is displayed as a mini card that shows important details like the version name, user, date, and method used. Tooltips provide additional descriptions for each session.
- Multi-Select Option: Users can select multiple sessions to compare. When selected, the app will prepare to join these sessions based on the account_id key column.
- The joining method is a right join, meaning data from the first selected session acts as the base, and other sessions are matched against it. If no common accounts exist, the joined data remains unaffected.

## Right Panel - Displaying Merged Data
- Joined Data View: Once users select sessions, the right panel updates to display a table showing the merged data. This allows users to see how accounts compare across different sessions side by side.
- If no sessions are selected, a message prompts users to choose sessions for comparison.
- if there is no union between the joined data then the first selected dataset is displayed. 
- Data Processing and Export: Users can provide a file name and export the joined data back into saved as a CSV files back to [compare_sessions](managed_folder:LvSKpnPJ) folder in Dataiku Flow. The data is saved as a CSV file in a designated compare_sessions folder within Dataiku.


# Connection to Dataiku Flow
## Session Retrieval and Management
The app reads session metadata directly from Dataiku’s metadata_dataset. Each session's details, including name, version, and user, are accessible for users to select. This ensures that users can always pick the latest and most relevant sessions for comparison. The compare_sessions folder in Dataiku is designated to store the results, ensuring seamless data integration.
## Data Merging
When users select multiple sessions, the app constructs paths to the relevant files within Dataiku's [segmentation_versions_folder](managed_folder:SyyDkxtP), retrieves the data, and merges them based on the ```account_id``` key column.
## Exporting Merged Data
Users can export the merged data to a Dataiku-managed folder, creating a new CSV file. By creating an object dataset in the flow users are encouraged to further exploration, analyse, or integrate with other data pipelines in Dataiku, enhancing the utility of segmentation comparisons.

