# Case Study: Enhancing Provider Engagement to Increase Market Share Using Data-Driven Segmentation

This case study offers a walkthrough of the solution using synthesized marketing data.

# Company Background
HealthPlus Pharmaceuticals, a mid-sized pharmaceutical company, has a critical psychiatric medication on the market, YummyDrug™, for treating severe anxiety that is not yet meeting commercial expectations to address the mental health market needs. The company wants to optimize marketing campaign resources better to effectively reach and engage targeted healthcare professionals (psychiatrists or HCPs with a specialty in mental health) through the right tailored communication channels based on engagement behavior to increase prescription volume and thus increase market share.

## Initial Situation
- Thousands of potential HCP targets nationwide
- Traditional segmentation in the past was based only on prescription volume with a current One-size-fits-all marketing approach
- A growing amount of sales rep activities are resulting in unsuccessful interactions/engagement
- Marketing ROI is below the industry average

## Data
HealthPlus has collected data on healthcare providers, including:
- Account Details: account ID, parent account, and specialty.
- Engagement Metrics: frequency of prescriptions, patient volume, communication preferences, and engagement rates.
- Communication Channels: number of face-to-face visits, web calls, phone calls, emails, and online page visits.
- Business Metrics: total prescriptions, revenue, and network strength.

## Goal
The company aims to increase the total prescriptions and thus access to the addressable patient population that can benefit from YummyDrug™ by understanding provider communication preferences and aligning their marketing and operations strategies accordingly.

## Insights

### Step 1: Data Exploration & Filtering
Using the [New Segmentation](web_app:UcGqC6v) web application, the marketing analytics team begins by filtering the dataset to focus on HCPs with specialty Psychiatry based in hospitals. They are particularly interested in analyzing engagement patterns across different communication channels to gain insights into how these providers interact with the company.

![1.png](IVwxEUG416OF)

### Step 2: Applying Machine Learning-Based Segmentation
After filtering, the marketing team utilizes Machine Learning-based segmentation (k-means clustering) option in the webapp to analyze communication preferences and group HCPs into three segments. 

![2.png](XC37T6DCrgWP)

### Step 3: Developing a Targeted Marketing Campaign
Based on the ML-based segmentation, marketing  segment providers into three categories: Traditional Communicators: Those who primarily engage through face-to-face visits and phone calls, Digital Communicators: Providers who prefer online communication (emails, and page visits) and Mixed Communicators: Providers utilizing a combination of traditional and digital methods. This segmentation helps the marketing team understand which groups might benefit from personalized campaigns tailored to their preferred communication channels.

![3.png](0OCDWiWRhFXj)

Upon analyzing segmentation insights and feature distributions across segments, the marketing team discovers that Traditional Communicators have lower engagement rates but higher patient volumes. The team hypothesizes that these providers could potentially drive higher prescription rates if they receive more effective communication. A marketing campaign is launched to engage these providers using customized in-person events and phone-based follow-ups, aligning with their preferred communication channels.
![4.png](6FGHLAiO97pa)

### Step 4: Identifying Low Prescription Providers for Operational Intervention
The sales resource operations team utilizes the webapp’s Rule-Based Segmentation option to complement the marketing efforts. They apply rules focusing on Total Prescriptions and Frequency of Prescriptions with more weight on the Volume of Prescriptions as a more important variable in this analysis.  

![5.png](ej366CTjrPU0)

Based on the distribution and heatmap insights they highlight the providers with a low total prescription count. 
![7.png](8vcvSjgHsuVo)

### Step 5: Coordinating Between Marketing and Operations
The operations and marketing teams collaborate in the [Compare Segmentations](web_app:vJbijSD) webapp to flag low-prescribing providers who engage primarily through face-to-face visits. Additional field representatives are allocated to engage them more frequently and support patient consultation. Customized marketing materials and resources are also provided to these field representatives to ensure a cohesive, personalized engagement experience.
![8.png](d0teDKboHlDO)

### Step 6: Evaluating the Impact of Marketing & Operational Initiatives
A few months after the campaign, the teams revisited the [Update Segmentation](web_app:cqlY94p) to analyze the results. They reapply the Rule-Based Segmentation on the updated dataset to assess any changes.
![9.png](uyWBzbgRSWuV)
### Step 7: Observing Positive Outcomes
The follow-up segmentation reveals significant improvements. Certain providers initially categorized as low prescribers have moved to the high prescriber segment. The engagement rate of the targeted providers improved, indicating higher responsiveness and communication through their preferred channels. Total prescriptions increased across the board, with the most significant gains observed among the Traditional Communicator segment.

## Business Impact
Through a combination of machine learning-based and rule-based segmentation, HealthPlus successfully identified key provider segments that required attention. By aligning marketing strategies and operational resources, the company:
- Improved total prescriptions by X% within the targeted provider group.
- Enhanced overall engagement rates by delivering personalized, channel-specific marketing.
- Enabled the operations team to efficiently allocate resources to providers who would benefit most, resulting in improved ROI on marketing and field operations.

## Conclusion
This case study illustrates how HealthPlus used data segmentation to better understand provider behavior, implement targeted marketing strategies, and achieve improved business outcomes. The Dash web application facilitated seamless data exploration, segmentation, and collaboration between teams, enabling data-driven decision-making that had a tangible impact on their business.