Data preparation and feature engineering steps should be done in a separate project to match the expected input dataset format. Beyond the simple data structure required, this article provides suggestions for data and features that such a solution can process for successful user/business stories.
## Required Input Data
The solution requires an input dataset on the Dataiku Flow, including a key column ```account_id``` and at least one more feature of your preference. Ideally, the data should have multiple features in the form of integer, boolean, object, or string. 

![templatedata.png](lPwTTNC0FunS)

## Data Suggestions

[Omnichannel_marketing](dataset:Omnichannel_marketing) dataset provides an example of synthesized marketing data as indication of inputs. To fully realize the benefits of dynamic segmentation, users should consider integrating the following types of data:

 **Prescriber Profiles & Demographics** 
 - Basic Information: Name, specialty, location, years in practice.
 - Practice Type: Hospital-based, private practice, group practice, etc.
 - Prescriber Network Analysis: Identification of networks, affiliations, and referral patterns.
 
**Engagement Data** 
 - Historical Sales Rep Visits: Number of visits, frequency, outcomes, and feedback from HCP interactions.
 - Digital Engagement: Click-through rates on emails, webinar attendance, website interaction, and responses to digital marketing campaigns.
 - Event Participation: Attendance at medical conferences, workshops.
 
**Prescribing Behaviors** 
 - Medication Preferences: Top prescribed medications, brand loyalty, and prescribing trends over time.
 - Prescription Volume: Number of prescriptions per product and per category, refill rates, and seasonality patterns.
 - Patient Demographics & Profiles: Number of patients treated, age groups, disease stages, and comorbidities.
 
**Channel Preferences** 
 - Communication Preferences: Preferred communication method (email, phone, in-person, virtual).
 - Response Data: Response rates across different marketing channels, from digital to face-to-face engagements.
 
**Market & Competitor Data** 
 - Competitor Analysis: Share of voice in different regions, competitor product adoption, and market share.
 - Market Trends: Information on market changes, including new drug approvals, regulatory changes, and emerging therapeutic areas.

**Key Opinion Leaders (KOLs) Influence** 
 - Network Analysis: Identify HCPs who influence peers or are considered thought leaders within their specialty.
 - Publication & Research Activities: Research publications, involvement in clinical trials, and speaking engagements.