The flow gives a visual representation of the project. Each flow zones serves a specific purpose that will be explained in the following articles.

## Input Data

![inputdata_img.png](fIR2dKUyIz1P)
This [zone](flow_zone:UdX7Lc3) provides the space for any input objects. Users in charge of technical maintenance of this solution (data scientists or data engineers) can upload or import datasets from local machines, databases, or others. These datasets become available in the  [New Segmentation Designer](web_app:UcGqC6v) web app for building segmentations. If you use the [Omnichannel_marketing_old](dataset:Omnichannel_marketing_old) dataset to initiate a segmentation session, then the same dataset (or one with the same name) will feed the   [Segmentation Manager](web_app:cqlY94p)  web app to update the results in future versions. Hence, make sure that any new data values are updated within the same file (either manually or automatically by the underlined database) or in a data file with the same name as the original one used in the first segmentation (version 0), including the required features.

[Images](managed_folder:ZwIBEZhA) folder contains any images used by the [New Segmentation Designer](web_app:UcGqC6v) webapps for UX design.

## Metadata

![metadata_img.png](pQgmx31PDvJs)
This [zone](flow_zone:default) is designed to generate detailed specifications and metadata, which can be used for further analysis, reporting, or decision-making processes.
- This [recipe](recipe:generate_and_clean_metadata) triggers [clear_folders](scenario:CLEAR_FOLDERS) scenario that empties the content of all the output datasets and folders. Be carefule; run this recipe ONLY if you want to wipe out every built segmentation session with metadata and files. 

- [rule_based_specs_dataset](dataset:rule_based_specs_dataset): Stores the specifications of segmentation sessions that used the rule-based segmentation method. It includes columns like ```session_name```, ```bounds```, and ```weights```. This dataset is essential for understanding and reapplying the rules applied during the sessions, including any set boundaries and weights, in the future.

- [metadata_dataset](dataset:metadata_dataset) dataset captures information about every saved segmentation version session. Every time a webapp user creates or saves a segmentation version, a new record that includes columns such as``` session_name, segmentation_version, status, original_dataset, username```  , ```datetime, method, description, specifications, selected_features, and cluster_name_remap``` is created. This dataset serves as a detailed log file, documenting the specifics of each session, including who performed the session, when it was done, the methods and features used, and any relevant descriptions or specifications.

- [output_data_folder](managed_folder:YIM9iOet) stores the latest active version of a segmentation session (input processed data and ‘cluster’ column) that can feed information into other projects and stakeholders.

- [model_sessions_folder](managed_folder:TdqwWquP) stores pickle files of the machine learning model used when the K-means method is selected. The individual files include processors with applied data transformations and the model itself with important parameters necessary for future updates of sessions using machine learning.

- [segmentation_versions_folder](managed_folder:SyyDkxtP) stores all the versions, original and updated ones over time, as a backup place for future versioning or restoring of past data.

- The [compare_sessions](managed_folder:LvSKpnPJ) folder stores the joined data from the [Multi Segmentation Explorer](web_app:vJbijSD) web app, which the user can then download or export as a Dataiku object to explore on the platform.


