The Dataiku Application allows users to customize the forecast parameters and use the solution with their own data through a visual interface. To make further adjustments to the project, the users still have the ability to go into the flow to update parameters directly. 

## Data update disclaimer 
Before beginning the application setup, users should read the disclaimer carefully. They have two options to replace the demo datasets with new data: uploading data from a computer or connecting to a database.

![Screenshot 2023-01-16 at 15.19.17.png](tRcvvObPVujN)

## Option 1 - Data upload

If the user chooses to upload data from their computer, the [historical time series data](dataset:historical_ts_dataset) and the  [data to forecast](dataset:to_forecast_dataset) are uploaded by the user through the Dataiku application interface.

![Screenshot 2023-01-16 at 15.26.00.png](PdPNQWz7KBjC)

To refresh the project with new data, users can delete the existing datasets by clicking on the trash icon next to their name and then upload new files by dragging and dropping them or by clicking the "add a file" button.

After updating the datasets in the interface, users must press "check" to initiate the [Data upload - check schema](scenario:001CHECKSCHEMACONSISTENCYANDRESETVARIABLES) scenario, which will load the data, verify the schema, and build sync recipes to update the values and enforce the schema of the [historical_ts_data](dataset:historical_ts_data) and the  [to_forecast_data](dataset:to_forecast_data) datasets. 

## Option 2 - Data connection 

To update the project with new data, by picking the option to connect to a database, the user must update the connection settings section.

![Screenshot 2023-01-16 at 15.41.32.png](a8W5xGyZBWwa)

The project comes pre-configured with all datasets using the filesystem connection. The user can either keep this setup or change it to their preferred connection by modifying the connection settings section and clicking on "run" to reconfigure the flow connections. 

By clicking the links [historical_ts_data](dataset:historical_ts_data) and [to_forecast_data](dataset:to_forecast_data), the user will access the connection setting page and will be able to change the path to their datasets.

After updating the datasets in the interface, users must press "check" to initiate the [Data connections - check schema](scenario:002SCHEMA) scenario, which will load the data, verify the schema, and remove the two sync recipes from the flow along with their respecting input datasets.

## Forecast financial data section 

In the forecast financial data section, the user can select the number of lag values and the drivers to include in the advanced forecasting model. 

![Screenshot 2023-01-20 at 10.32.16.png](SBO8OgyURtIS)


Before configuring the parameters, the user should **refresh the page** to update the available options for drivers in the list. Then, the user can specify the number of lag values and select the drivers to include in the model. 

Additional information about lag values and drivers are provided in the respective following articles : [Data Preparation](article:11) and  [Data Model](article:8)

Finally, clicking the "run" button will initiate the [00. Run all scenarios](scenario:00RUNALLSCENARIOS) scenario and build the whole flow. 

Once the scenario completes running, the results will be displayed in the [Financial forecasting dashboard](dashboard:j4Pjdob). 





