import dataiku
#from commons.python.fetch.config_bs import ConfigBs, EnvMode
from .config import FFConfig
import os
from dotenv import load_dotenv

load_dotenv()

class DataikuClient:
    def __init__(self):
        self.__client = dataiku.api_client()
        #self.__project_key = os.getenv("DKU_CURRENT_PROJECT_KEY")
        #print(self.__project_key)
        self.__project_key = dataiku.get_custom_variables()["projectKey"]
        #self.__project_key = "SOL_FINANCIAL_FORECASTING_GENAI"
        self.__project = self.__client.get_project(self.__project_key)
        self.__variables = self.__project.get_variables()["standard"]

    @property
    def project(self):
        return self.__project
    
    @property
    def variables(self):
        return self.__variables

    @property
    def project_key(self):
        return self.__project_key

    @property
    def client(self):
        return self.__client