import axios from "./api/index";
import { AnswerData, AnswerRequest, BusinessUnit, BusinessUnits, EmailData } from "./models";

export let API = {
    getBusinessUnits: () => axios.get<BusinessUnits>(`/api/business_units`),
    generateEmail: (data: BusinessUnit) => axios.post<AnswerData>(`/api/generate_email`, data),
    sendInstruction: (data : AnswerRequest) => axios.post<AnswerData>(`/api/send_instruction`, data),
    saveReport: (data : EmailData) => axios.post<number>(`/api/save_report`, data),
    getSavedFolderUrl: () => axios.get<string>('/api/saved_folder_url')
}