export type BusinessUnit = { 
    business_unit: string;
}

export type BusinessUnits = { 
    business_units: BusinessUnit[];
}

export interface AnswerData {
    email: string;
    success_error: number;
}

export interface EmailData {
    email: string;
    business_unit: string;
}

interface ServerResponse<T> {
    status: "ok" | "ko";
    data: T
}

export interface AnswerRequest {
    query: string;
    history?: QuestionData[];
}

export interface QuestionData {
    query: string;
    email: string;
}

export type BusinessUnitsResponse = ServerResponse<BusinessUnits>;
export type AnswerResponse = ServerResponse<AnswerData>;

export const SESSION_STORAGE_HISTORY_KEY = 'financial-forecasting-history'
