# Walkthrough

##  Setting up the project

To setup the project, you simply need to go to its homepage and click on the **PROJECT SETUP** button. 

![Screenshot 2024-10-03 at 15.03.23.png](Unsqg3eHncgp)

In the project setup user interface, you can either load or connect to your own datasets, verify the validity of your data structure, and then click the run button to build the flow and generate the results.

![Screenshot 2024-01-25 at 10.01.12.png](k9V5ABLpMtvM)

## Reading the results

 **Slide 1 - Historical Lead Conversion** 
 
This slide provides a comprehensive overview of historical lead data, including the count over time, the trends in conversion rate and duration, as well as the touchpoint count categorized by type. 

![Screenshot 2024-01-25 at 10.33.43.png](0hQ432nGhOqb)

 **Slide 2 - Estimated conversion rate ** 
 
This page offers an in-depth perspective on the estimated lead conversion rate calculated from the classification model's results. A Conversion Model Score Table presents individual conversion rates, and the second chart illustrates the distribution of leads based on estimated conversion rates. Additionally, visual analyses from the classification model are showcased at the bottom of the slide.

![Screenshot 2024-01-25 at 10.34.00.png](jIETfpIUY9iz)

 **Slide 3 - Historical Customer Value**  

On this slide, you'll find historical analyses of customer value, featuring trends in average customer value over time. Additionally, there is information on customer count and average customer value, categorized and filtered by the additional columns integrated into the customer dataset.

![Screenshot 2024-01-25 at 10.38.39.png](cXZy51HIKX0Y)

 **Slide 4 - Expected Value Prediction ** 

This page highlights the results of the Estimated Customer Value computed by the regression model. The projected values are displayed in the Customer Value Table, and additional visual analyses derived from the model are showcased at the bottom of the slide.

![Screenshot 2024-01-25 at 10.39.13.png](vUpkE9i19n6S)

 **Slide 5 - Lead Scoring Results ** 

This slide exhibits the ultimate score assigned to each lead, computed by multiplying the conversion rate with the anticipated customer value linked to each lead.

Lead Value = Estimated Conversion Rate * Estimated Customer Value

![Screenshot 2024-01-25 at 10.39.41.png](Hv5Fec7DCD0w)

# Conclusion

With the Dataiku Lead Scoring Solution, sales and marketing teams efficiently adopt ML lead scoring techniques, and simultaneously unlock the power of internal and external data sources for greater lead insight. 

Outcomes are integrated into any existing marketing, CRM or related sales systems, creating a robust and complete marketing pipeline. 




