export function formatNumbers(value: number | string) {
  if(typeof value === 'string'){
    value = parseFloat(value)
  }
  return new Intl.NumberFormat(navigator.language, { maximumFractionDigits: 2 }).format(value)
}
export function formatDate(dateString: string | number) {
  // Making sure it parses both dates with and without times
  const dateObj = new Date(dateString);
  const full = `${dateObj.toLocaleString("default", {
      month: "short",
  })} ${dateObj.getDate()}, ${dateObj.getFullYear()}`;
  const month = dateObj.toLocaleString("default", {
      month: "short",
  });
  return {
      full,
      month,
      day: dateObj.getDate(),
      year: dateObj.getFullYear(),
      monthDayWithTimestamp: `${month} ${dateObj.getDate()}, \n ${dateObj.toLocaleTimeString("default")}`,
      fullWithTimestamp: `${full}, ${dateObj.toLocaleTimeString("default")}`,
      fullWithUSTimestamp: `${full}, ${dateObj.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit' })}`,
  };
}
export const CARD_LABELS = {
  "total_profit": "Profits",
  "forecasted_volume": "Forecasted Total Volume (Sales volume) (units)",
  "sellthrought_rate": "Sell through (%)",
  "margin_percent": "Margin (%)",
  "revenue": "Sales Revenue",
  "lost_sales": "Lost Sales Volumes (units)",
  "lost_profit": "Lost Sales",
}
export const CHART_LABELS = {
  "total_profit": "Profits",
  "forecasted_volume": "Sales Volume",
  "sellthrought_rate": "Sell through",
  "margin_percent": "Margin",
  "revenue": "Sales Revenues",
  "lost_sales": "Lost Sales Volumes",
  "lost_profit": "Lost Sales",
}
export const BIG_CARDS_KEYS = ["total_profit", "forecasted_volume"]
export const SMALL_CARDS_KEYS = ["sellthrought_rate", "margin_percent", "revenue", "lost_sales", "lost_profit"]
// labels that should have currency added
export const LABELS_WITH_CURRENCIES = ["total_profit", "revenue", "lost_profit"]

export const chartLabelsStyle = {
  color: "#666",
  fontSize: 14,
  fontFamily: "SourceSansPro",
  fontStyle: "normal",
  fontWeight: "600",
  lineHeight: 18,
  overflow: 'break'
};
export function appendCurrency(key: string, currency: string){
  const label = CARD_LABELS[key] || key;
  return LABELS_WITH_CURRENCIES.includes(key)
      ? `${label} (${currency})`
      : label;
};