from ...dku_utils import get_current_project_and_variables


def check_automation_prerequisites():
    project, variables = get_current_project_and_variables()

    local_variables = variables["local"]
    rules_transactions_dates_filtering_strategy = local_variables["rules_transactions_dates_filtering_strategy"]
    customer_transaction_dates_filtering_strategy = local_variables["customer_transaction_dates_filtering_strategy"]

    flow_refresh_condition = (rules_transactions_dates_filtering_strategy == customer_transaction_dates_filtering_strategy == "keep_transactions_before_and_until_today")
    if not flow_refresh_condition:
        log_message = \
        "Flow refresh over time can only work with dates filtering strategies equals to 'Keep transactions before and until today' "\
        "for both 'Rules transactions dates filtering settings' and 'Customers transactions dates filtering settings'. "\
        "Please modify the 'dates filtering strategy' in that two dataiku application tiles."
        raise Exception(log_message)
        pass
    pass