# Definition

The **support** of a rule is the **proportion of transactions** which contains both the itemsets ***X*** and ***Y***.
It is noted <span style="color:#9900FE">**supp(**</span>***X => Y *** <span style="color:#9900FE">**)**</span> or <span style="color:#9900FE">**supp(**</span>***X U Y *** <span style="color:#9900FE">**)**</span>.
- Here <span style="color:#9900FE">**supp(**</span>***X U Y *** <span style="color:#9900FE">**)**</span> means the support of the union of the items present in the itemsets ***X*** and ***Y*** *(Since support is by design defined for itemsets)*.

# Formula

![rule_support formula.png](JGrThYGj4QOR)

# Concept diving
- It is a measure of the **association rule's likelihood**: The higher the support of a rule is, the more likely it's antecedent and consequent are to occur together. 

- <span style="color:#9900FE">**supp(**</span>***X U Y*** <span style="color:#9900FE">**)**</span> **is in [0, 1]**.


# Regarding our case study

- We have a total of 5 transactions
- **<span style="color:#1D4587">onion</span>** and **<span style="color:#1D4587">pepper</span>** were purchased together in 2 transactions: "t_1" and "t_2".
  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">onion => pepper</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">onion, pepper</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4 .
  - That means that 40 % of transactions contains <span style="color:#1D4587">***onion & pepper***</span>. 
- **<span style="color:#990002">chicken</span>** and **<span style="color:#990002">tomato</span>** were purchased together in 3 transactions: "t_1", "t_2" and "t_5".
  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">chicken => tomato</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">chicken, tomato</span>}**<span style="color:#9900FE">**)**</span> = 3/5 = 0.6 .
  - That means that 60 % of transactions contains <span style="color:#990002">***chicken & tomatoes***</span>. 

![rules_support.png](kuHhBVVlRlfP)                    