# Definition

The **lift** of a rule measures **how much using a rule is better than relying only on its consequent likelihood taken independently**.
It is noted <span style="color:#9900FE">**lift(**</span>***X => Y *** <span style="color:#9900FE">**)**.
  
# Formula

![rule_lift_formula.png](pOqf2xH65JJU)

[I don't remember what is the rule support](article:25)
[I don't remember what is the rule confidence](article:26)

# Concept diving

- It is a measure of the **association rule's power** : The higher the lift of a rule is, the more valuable it is to use it.
- The lift also indicates the **strength of the dependency relationship** between the antecedent and the consequent itemsets.
- <span style="color:#9900FE">**lift(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> **is in [0, +inf]**.
  - If <span style="color:#9900FE">**lift(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> > 1: That suggests that the ***antecedent*** and the ***consequent*** itemset are dependent on one another. Itemsets are more often bought together than independently.
  -  If <span style="color:#9900FE">**lift(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> <= 1: Itemsets are statistically independent.


# Regarding our case study

- We have a total of 5 transactions.

- Rule **{<span style="color:#1D4587">pepper,onion => mushroom</span>}**:

  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span>  = 1.
  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">mushroom</span>}**<span style="color:#9900FE">**)**</span> = 3/5 = 0.6. 
  - Finally : <span style="color:#9900FE">**lift(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**conf(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">mushroom</span>}**<span style="color:#9900FE">**)**</span> = 1 / 0.6 = 1.67
  - Purchasing <span style="color:#1D4587">**mushroom**</span> seems to be dependent on purchasing <span style="color:#1D4587">**pepper & onion**</span> .

![rules_lift_p3.png](iajhGiftguow)

- Rule **{<span style="color:#990002">tomato => salad</span>}**: 
  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4.
    - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4.
  - Finally : <span style="color:#9900FE">**lift(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4 / 0.4 = 1.
  - <span style="color:#990002">**tomato**</span> and <span style="color:#990002">**salad**</span> seems to be independent products.

![rules_lift_p2.png](y4wdojJr9C6O)

- Rule **{<span style="color:#7F6000">onion => tortilla</span>}**:
  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.5.
  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#7F6000">tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.6.
  - Finally : <span style="color:#9900FE">**lift(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**conf(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#7F6000">tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.5 / 0.6 = 0.83.
  - <span style="color:#7F6000">**onion**</span> and <span style="color:#7F6000">**tortilla**</span> seems to be independent products.

![rules_lift_p1.png](Gj1WkIdrVsRA)