# Definition

The **conviction** of a rule measures **the strength of the dependency of the consequent itemset to the antecedent itemset**.
It is noted <span style="color:#9900FE">**conv(**</span>***X => Y *** <span style="color:#9900FE">**)**.
  
# Formula

![rule_conviction_formula.png](QkIM3ZxNVg8g)

[I don't remember what is the rule support](article:25)
[I don't remember what is the rule confidence](article:26)

# Concept diving

- It is the ratio of expected support of X occurring without Y (assuming X and Y are independent) to the observed support of X occurring without Y. 
- A high conviction means that the consequent is highly dependent on the antecedent:
  - When <span style="color:#9900FE">**conf(**</span>***X => Y *** <span style="color:#9900FE">**)**</span> is maximum, the denominator equals 0 : Thus, <span style="color:#9900FE">**conv(**</span>***X => Y *** <span style="color:#9900FE">**)**</span> diverges towards infinite.
- <span style="color:#9900FE">**conv(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> **is in [0, +inf]**.
  - If <span style="color:#9900FE">**conv(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> > 1: That suggests that the ***consequent*** itemset strongly depends on the ***antecedent*** itemset. 
  -  If <span style="color:#9900FE">**conv(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> <= 1: That suggests that the ***consequent***  and the***antecedent*** itemset are statistically independent.

# Regarding our case study

- We have a total of 5 transactions.

- Rule **{<span style="color:#1D4587">pepper,onion => mushroom</span>}**:

  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">mushroom</span>}**<span style="color:#9900FE">**)**</span> = 3/5 = 0.6. 
  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span>  = 1.
  - Finally : <span style="color:#9900FE">**conv(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span>  = (1 - 0.6) / (1 - 1) = +inf.
  - Purchasing <span style="color:#1D4587">**mushroom**</span> seems to be highly dependent of purchasing <span style="color:#1D4587">**pepper & onion**</span> .

![rules_conviction_p3.png](xYlme9cYkoJY)

- Rule **{<span style="color:#990002">tomato => salad</span>}**: 
    - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4.
    - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4.
  - Finally : <span style="color:#9900FE">**conv(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = (1 - 0.4) / (1 - 0.4) = 1.
  - <span style="color:#990002">**tomato**</span> and <span style="color:#990002">**salad**</span> seems to be independent products.

![rules_conviction_p2.png](c5K5HoP8nFqY)

- Rule **{<span style="color:#7F6000">onion => tortilla</span>}**:
  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#7F6000">tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.6.
  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.5.
  - Finally : <span style="color:#9900FE">**conv(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span>  = (1 - 0.6) / (1 - 0.5) = 0.8.
  - <span style="color:#7F6000">**onion**</span> and <span style="color:#7F6000">**tortilla**</span> seems to be independent products.

![rules_conviction_p1.png](TS8NRBRAlXXc)