# Flow zone presentation

![recommendations_preprocessing.png](YipQfSXh6u9O)

Here are the main steps of that flow zone:

 - **Filtering on the transaction dates kept for customers purchases** : recipe [compute_transactions_customers_filtered_dates](recipe:compute_transactions_customers_filtered_dates)
 
 - **Filtering of the last N transactions within the valid transaction dates period**: recipe [compute_customers_last_transactions](recipe:compute_customers_last_transactions) computes a denserank of customer's transactions and uses a post-filter to retrieve the last "N" ones ("N" being a parameter you can play on with the "last parameter scope" in the Dataiku application).
 
 - **Computation of all the distinct items purchased by customers within the filtered transactions**: this is done by the recipe [compute_customers_last_transactions_unique_items](recipe:compute_customers_last_transactions_unique_items). It leads to the dataset [customers_last_transactions_unique_items_prepared](dataset:customers_last_transactions_unique_items_prepared).
 
 - **Computation of all the unique customers that purchased** : this is done by the recipe [compute_unique_customers](recipe:compute_unique_customers).
 
 - **Computation of all the potential consequents each customer could purchase**: recipe [compute_consequents_potential_customers](recipe:compute_consequents_potential_customers)  crosses each existing consequent within the association rules with each customer id. This leads to the dataset of all consequent potential customers, [consequents_potential_customers](dataset:consequents_potential_customers). 
   - This dataset has a number of rows equal to *number_of_consequent_items* X *number_of_customers*. 
   - Dataset granularity: 1 row = 1 combination between 1 consequent and 1 customer.
   - This is allowed by using recipe [compute_unique_consequent_items]. (recipe:compute_unique_consequent_items) on dataset, [rules_denormalized_consequents](dataset:rules_denormalized_consequents)  ([What is that dataset ?](article:57)) to get the list of all the association rules consequents.
   
 - **Computation of all the "cross sales" and "up sales" (understand "repeat purchase") candidate consequents**. This is done by crossing the dataset [consequents_potential_customers] with [customers_last_transactions_unique_items_prepared](dataset:customers_last_transactions_unique_items_prepared).
   - Recipe [compute_cross_sales_candidate_consequents](recipe:compute_cross_sales_candidate_consequents)
     keeps all the rows where the consequent item was NOT purchased by a customer. Finally, recipe [compute_cross_sales_candidate_consequents_prepared](recipe:compute_cross_sales_candidate_consequents_prepared) prepares this  dataset for the [cross_sales_recommendations](article:47).
   - Recipe [compute_up_sales_candidate_consequents](recipe:compute_up_sales_candidate_consequents)
     keeps all the rows where the consequent item was purchased by a customer. Finally, recipe [compute_up_sales_candidate_consequents_prepared](recipe:compute_up_sales_candidate_consequents_prepared) prepares this  dataset for the [repeat_purchase_recommendations](article:46).